/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.ArchiveNotFoundException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.archive.container.SimpleContainer;
import de.lwsystems.mailarchive.config.AbstractContainerConfig;
import de.lwsystems.mailarchive.config.ConfigurationException;
import de.lwsystems.mailarchive.config.ConfiguredContainerGeneratorConfig;
import de.lwsystems.mailarchive.config.IContainerConfig;
import de.lwsystems.mailarchive.config.ISimpleContainerConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConfiguredContainerGenerator
implements IContainerGenerator {
    private static final Logger LOGGER = Logger.getLogger(ConfiguredContainerGenerator.class);
    private final Map<String, IContainer> containers;
    private final IArchive archive;
    private final Benno benno;
    private final boolean readOnly;

    public ConfiguredContainerGenerator(Benno benno, IArchive archive, ConfiguredContainerGeneratorConfig config, boolean readOnly) throws IOException, ConfigurationException {
        this.archive = archive;
        this.benno = benno;
        this.readOnly = readOnly;
        this.containers = new HashMap<String, IContainer>();
        this.updateContainers(config);
    }

    private void updateContainers(ConfiguredContainerGeneratorConfig config) throws ConfigurationException {
        HashSet<String> unconfiguredContainers = new HashSet<String>();
        unconfiguredContainers.addAll(this.getContainerMap().keySet());
        for (AbstractContainerConfig container : config.containers) {
            try {
                if (this.getContainerMap().containsKey(container.identifier)) {
                    this.getContainerMap().get(container.identifier).configure(container);
                    continue;
                }
                this.addContainer(container.identifier, this.getContainer(this.benno, container, this.archive, this.readOnly));
            }
            catch (ArchiveException ex) {
                LOGGER.error(null, (Throwable)ex);
            }
            catch (IOException e) {
                throw new ConfigurationException((IBoxHolder)this.getArchive(), e);
            }
        }
        for (String identifier : unconfiguredContainers) {
            IContainer container = this.getContainerMap().get(identifier);
            container.close();
            this.removeContainer(identifier);
        }
    }

    private IContainer getContainer(Benno benno, IContainerConfig container, IArchive archive2, boolean readOnly) throws ArchiveException, IOException {
        if (container instanceof ISimpleContainerConfig) {
            ISimpleContainerConfig containerConfig = (ISimpleContainerConfig)container;
            return new SimpleContainer(benno, this.archive, containerConfig, readOnly);
        }
        throw new RuntimeException("bad config");
    }

    @Override
    public final IArchive getArchive() {
        return this.archive;
    }

    protected final Map<String, IContainer> getContainerMap() {
        return this.containers;
    }

    @Override
    public final Iterable<IContainer> getContainers() {
        return this.containers.values();
    }

    @Override
    public final IContainer getContainer(String name) throws ArchiveNotFoundException {
        IContainer container = this.containers.get(name);
        if (container == null) {
            throw new ArchiveNotFoundException(name);
        }
        return container;
    }

    protected final void addContainer(String identifier, IContainer container) {
        this.containers.put(identifier, container);
    }

    protected final void removeContainer(String identifier) {
        this.containers.remove(identifier);
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        DocumentId documentId = null;
        int containerCounter = 0;
        for (IContainer container : this.getContainers()) {
            ++containerCounter;
            try {
                documentId = container.addDocument(document);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("Store Message in container " + container.getIdentifier() + "/" + documentId.getFullDocumentId()));
            }
            catch (NonFailingArchivingException ex) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Message not archived in container \"" + container.getIdentifier() + "\""), (Throwable)ex);
            }
        }
        if (containerCounter == 0) {
            throw new FailedArchivingException(document, "No write permission on any container");
        }
        if (documentId == null) {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria of any container");
        }
        return documentId;
    }

    public boolean optimizeIndex() {
        boolean successful = true;
        for (IContainer container : this.getContainers()) {
            successful = container.optimizeIndex() && successful;
        }
        return successful;
    }

    @Override
    public void shutdown() {
        for (IContainer container : this.getContainers()) {
            container.close();
        }
    }

    @Override
    public void configure(ConfiguredContainerGeneratorConfig config) throws ConfigurationException {
        this.updateContainers(config);
    }
}

