/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.journal;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.journal.FSJournal;
import de.lwsystems.mailarchive.config.xml.QuarterlyFSJournalConfig;
import de.lwsystems.mailarchive.utils.Clock;
import de.lwsystems.mailarchive.utils.DateUtil;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class QuarterlyFSJournal
extends FSJournal {
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyy", Locale.ROOT);

    public QuarterlyFSJournal(IBox box, File directory, boolean readOnly) throws ArchiveException {
        super(box, directory, readOnly);
    }

    public QuarterlyFSJournal(IBox box, QuarterlyFSJournalConfig config, File directory, boolean readOnly) throws ArchiveException {
        super(box, config, directory, readOnly);
    }

    @Override
    protected synchronized String getCurrentPart() {
        String date = DATEFORMAT.format(Clock.getProvider().newDate());
        Calendar calendar = Clock.getProvider().getCalendarInstance(Locale.ROOT);
        return DateUtil.getQuartalString(date, calendar);
    }
}

