/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.condition;

import de.lwsystems.mailarchive.condition.AbstractCondition;
import de.lwsystems.mailarchive.condition.ConditionConfigType;
import de.lwsystems.mailarchive.config.ConditionMailAddressConfig;
import de.lwsystems.mailarchive.config.IConditionConfig;
import de.lwsystems.mailarchive.maildocument.MailMetaData;

@ConditionConfigType(value=IConditionConfig.ConditionType.MAILADDRESS)
public class MailAddressCondition
extends AbstractCondition {
    private final boolean matchSender;
    private final boolean matchRecipient;
    private final boolean matchFrom;
    private final boolean matchTo;
    private final boolean matchCc;
    private final String mailAddress;

    public MailAddressCondition(ConditionMailAddressConfig config) {
        this.matchSender = config.matchSender;
        this.matchRecipient = config.matchRecipient;
        this.matchFrom = config.matchFrom;
        this.matchTo = config.matchTo;
        this.matchCc = config.matchCc;
        this.mailAddress = config.mailAddress;
    }

    @Override
    public boolean matches(MailMetaData metaData) {
        boolean bRet = false;
        bRet = bRet || this.matchSender && metaData.matchSender(this.mailAddress);
        bRet = bRet || this.matchRecipient && metaData.matchRecipient(this.mailAddress);
        bRet = bRet || this.matchFrom && metaData.matchFrom(this.mailAddress);
        bRet = bRet || this.matchTo && metaData.matchTo(this.mailAddress);
        bRet = bRet || this.matchCc && metaData.matchCc(this.mailAddress);
        return bRet;
    }

    @Override
    public boolean isAlwaysTrue() {
        return !this.isAlwaysFalse() && this.mailAddress.length() == 0;
    }

    @Override
    public boolean isAlwaysFalse() {
        return !this.matchSender && !this.matchRecipient && !this.matchFrom && !this.matchTo && !this.matchCc;
    }
}

