/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.index;

import de.lwsystems.mailarchive.maildocument.DocumentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.lucene.document.Document;

public class ObservedDocument {
    private Document document;
    private List<DocumentListener> listeners = new ArrayList<DocumentListener>();
    private Future<Void> indexingFuture;

    public ObservedDocument(Document document) {
        this.document = document;
    }

    public void addDocumentListener(DocumentListener listener) {
        this.listeners.add(listener);
    }

    public Document getDocument() {
        return this.document;
    }

    public void onIndexingFinished() {
        for (DocumentListener listener : this.listeners) {
            listener.indexingFinished();
        }
    }

    public void error(Exception ex) {
        for (DocumentListener listener : this.listeners) {
            listener.indexingError(ex);
        }
    }

    public void setIndexingFuture(Future<Void> f) {
        this.indexingFuture = f;
    }
}

