/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.mailservice;

import com.google.common.eventbus.EventBus;
import de.lwsystems.mailarchive.event.DeliveredEvent;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocumentListener;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.IMailListener;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import de.lwsystems.mailarchive.parser.IFileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

class BennoFileProcessor {
    private static final Logger LOGGER = Logger.getLogger(BennoFileProcessor.class);
    private final File directory;
    private final IFileParser fileParser;
    private final List<IMailListener> listeners;
    private final EventBus eventBus;
    private boolean destroyed;

    public BennoFileProcessor(File directory, IFileParser fileParser, List<IMailListener> listeners, EventBus eventBus) {
        this.directory = directory;
        this.fileParser = fileParser;
        this.listeners = listeners;
        this.eventBus = eventBus;
    }

    private File renameFile(Path filePath) throws IOException {
        String inprocessFilename = filePath.getFileName() + ".processing";
        Path inprocessFilePath = FileSystems.getDefault().getPath(this.directory.getAbsolutePath(), inprocessFilename);
        Files.move(filePath, inprocessFilePath, StandardCopyOption.ATOMIC_MOVE);
        return inprocessFilePath.toFile();
    }

    public void processFile(Path filename) {
        Date date = new Date();
        final long ts = new Timestamp(date.getTime()).getTime();
        File file = null;
        try {
            final File processedFile = file = this.renameFile(filename);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Read file " + file.getAbsolutePath()));
            }
            MailDocument document = this.fileParser.parseFile(processedFile);
            document.addMailDocumentListener(new MailDocumentListener(){

                @Override
                public void processingCompleted() {
                    processedFile.delete();
                }

                @Override
                public void processingError(Exception ex) {
                    LOGGER.error((Object)("Error processing file \"" + processedFile.getAbsolutePath() + "\""), (Throwable)ex);
                    processedFile.renameTo(new File(processedFile.getAbsolutePath() + "-" + String.valueOf(ts) + ".err"));
                }
            });
            if (this.deliverMail(document)) {
                document.archivingSuccessful();
            } else {
                LOGGER.warn((Object)("Problem archiving email file " + file.getAbsolutePath()));
                file.renameTo(new File(file.getAbsolutePath() + "-" + String.valueOf(ts) + ".err"));
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.error((Object)"Listed file not found (had been removed before it could be read", (Throwable)ex);
        }
        catch (ParserException ex) {
            LOGGER.error((Object)("Error parsing file \"" + file.getAbsolutePath() + "\""), (Throwable)ex);
            file.renameTo(new File(file.getAbsolutePath() + "-" + String.valueOf(ts) + ".err"));
        }
        catch (IOException ex) {
            LOGGER.error((Object)"File could not be moved", (Throwable)ex);
        }
    }

    protected boolean deliverMail(MailDocument mail) {
        boolean successful = true;
        if (!this.isDestroyed()) {
            for (IMailListener listener : this.listeners) {
                try {
                    DocumentId documentId = listener.addDocument(mail);
                }
                catch (NonFailingArchivingException ex) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Email \"" + mail.toString() + "\" was not archived by \"" + listener.toString() + "\""), (Throwable)ex);
                    }
                    mail.indexingFinished();
                }
                catch (FailedArchivingException ex) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)("Problem archiving email " + ex));
                    }
                    successful = false;
                }
            }
            if (this.eventBus != null) {
                this.eventBus.post((Object)new DeliveredEvent(mail));
            }
        } else {
            successful = false;
        }
        return successful;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }
}

