/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import java.net.JarURLConnection;
import java.text.SimpleDateFormat;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class RunUtil {
    private static final Logger LOGGER = Logger.getLogger(RunUtil.class);

    public static String buildInfo() {
        try {
            String bc = RunUtil.class.getName().replace('.', '/') + ".class";
            JarURLConnection j = (JarURLConnection)ClassLoader.getSystemResource(bc).openConnection();
            long buildTS = j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String buildTime = formatter.format(buildTS);
            return buildTime;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot read build time");
            LOGGER.info((Object)e);
            return "2017-06-01 00:00:00";
        }
    }

    public static String coreBuildTime() {
        try {
            String coreClass = "de/lwsystems/mailarchive/Benno.class";
            JarURLConnection jarConnection = (JarURLConnection)ClassLoader.getSystemResource(coreClass).openConnection();
            long buildTS = jarConnection.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmss");
            String buildTime = formatter.format(buildTS);
            return buildTime;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot read bennocore build time");
            LOGGER.info((Object)e);
            return "20000000000000";
        }
    }

    public static String coreVersion() {
        try {
            String coreClass = "de/lwsystems/mailarchive/Benno.class";
            JarURLConnection jarConnection = (JarURLConnection)ClassLoader.getSystemResource(coreClass).openConnection();
            Manifest manifest = jarConnection.getManifest();
            String coreVersion = manifest.getMainAttributes().getValue("Implementation-Version");
            return coreVersion;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot read bennocore version");
            LOGGER.info((Object)e);
            return "2.0.0";
        }
    }
}

