/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive;

import de.lwsystems.mailarchive.IBennoApplication;
import org.apache.log4j.Logger;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class BennoSignalHandler
implements SignalHandler {
    private static final Logger LOGGER = Logger.getLogger(BennoSignalHandler.class);
    private SignalHandler originalHandler;
    private IBennoApplication bennoApplication;

    public BennoSignalHandler(String signalName, IBennoApplication bennoApplication) {
        this.bennoApplication = bennoApplication;
        this.originalHandler = Signal.handle(new Signal(signalName), this);
    }

    @Override
    public void handle(Signal signal) {
        LOGGER.info((Object)("Signal handler called for signal " + signal));
        if (signal.getName().equals("HUP")) {
            this.bennoApplication.reload();
        } else {
            try {
                this.bennoApplication.shutDown();
                if (this.originalHandler != SIG_DFL && this.originalHandler != SIG_IGN) {
                    this.originalHandler.handle(signal);
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)("handle|BennoSignalHandler failed, reason " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }
}

