/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.BoxGeneratorFactory;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IndexFactory;
import de.lwsystems.mailarchive.condition.AbstractCondition;
import de.lwsystems.mailarchive.condition.ConditionFactory;
import de.lwsystems.mailarchive.config.BoxGeneratorConfig;
import de.lwsystems.mailarchive.config.ConditionOrConfig;
import de.lwsystems.mailarchive.config.ConfigurationException;
import de.lwsystems.mailarchive.config.ContainerConfig;
import de.lwsystems.mailarchive.config.ISimpleContainerConfig;
import de.lwsystems.mailarchive.index.IIndex;
import de.lwsystems.mailarchive.maildocument.ArchivedMailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class SimpleContainer
implements IBoxHolder,
IContainer {
    private final Logger LOGGER = Logger.getLogger(SimpleContainer.class);
    private final IBoxGenerator boxGenerator;
    private final IIndex index;
    private final String identifier;
    private final IArchive archive;
    private AbstractCondition condition;
    private final boolean readOnly;
    private final boolean isScidActive;

    public SimpleContainer(Benno benno, IArchive archive, ISimpleContainerConfig config, boolean readOnly) throws ArchiveException, IOException {
        this.readOnly = readOnly;
        this.boxGenerator = this.getBoxGenerator(archive, config.getBoxGenerator(), readOnly);
        this.archive = archive;
        this.condition = this.getCondition(config.getCondition());
        this.identifier = config.getIdentifier();
        this.isScidActive = config.isScidActive();
        this.index = IndexFactory.createIndex(benno, config.getIndex(), this, readOnly);
    }

    private AbstractCondition getCondition(ConditionOrConfig config) {
        return ConditionFactory.createCondition(config);
    }

    private IBoxGenerator getBoxGenerator(IArchive archive, BoxGeneratorConfig iBoxGeneratorConfig, boolean readOnly) throws ArchiveException {
        return BoxGeneratorFactory.createBoxGenerator(archive, iBoxGeneratorConfig, readOnly);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public IBoxGenerator getBoxGenerator() {
        return this.boxGenerator;
    }

    @Override
    public final boolean doesMatch(MailMetaData metaData) {
        return this.condition.matches(metaData);
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public String getState() {
        return this.isReadOnly() ? ", readonly" : "";
    }

    @Override
    public final IArchive getArchive() {
        return this.archive;
    }

    public final IContainer getContainer() {
        return this;
    }

    public IIndex getIndex() {
        return this.index;
    }

    @Override
    public boolean optimizeIndex() {
        return this.getIndex().optimize();
    }

    @Override
    public void configure(ContainerConfig container) throws ConfigurationException {
        if (!(container instanceof ISimpleContainerConfig)) {
            throw new ConfigurationException((IBoxHolder)this, "wrong type of configuration for container " + this.getIdentifier());
        }
        ContainerConfig containerConfig = container;
        this.boxGenerator.configure(containerConfig.getBoxGenerator());
        this.index.configure(containerConfig.getIndex());
    }

    @Override
    public boolean addRemoveRepoJournalEntry(MailDocument document) throws FailedArchivingException {
        if (this.doesMatch(document.getMetaData())) {
            this.boxGenerator.addRemoveRepoJournalEntry(document);
        }
        return true;
    }

    @Override
    public Directory getIndexPath() {
        return this.getIndex().getDirectory();
    }

    @Override
    public String getIndexPathString() {
        return this.getIndex().getIndexPathString();
    }

    @Override
    public ArchivedMailDocument addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        ArchivedMailDocument archivedMailDocument;
        if (this.doesMatch(document.getMetaData())) {
            archivedMailDocument = this.boxGenerator.addDocument(document);
            if (archivedMailDocument != null) {
                this.getIndex().addDocument(archivedMailDocument);
            } else {
                this.LOGGER.error((Object)("Document not (re-added) to index, please see preceeding errors for cause: " + document.getMetaData().getHashHex()));
            }
        } else {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria");
        }
        return archivedMailDocument;
    }

    @Override
    public RemovedMailDocument removeDocument(MailDocument document, String mode) throws ArchiveException, FailedArchivingException, IOException, NonFailingArchivingException {
        RemovedMailDocument removedMailDocument = null;
        if (this.doesMatch(document.getMetaData())) {
            removedMailDocument = this.boxGenerator.removeDocument(document, mode);
            if (removedMailDocument != null) {
                this.getIndex().removeDocument(removedMailDocument, mode);
            } else {
                this.LOGGER.error((Object)("Document not removed from index, please see preceeding errors for cause: " + document.getMetaData().getHashHex()));
            }
        } else {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria");
        }
        return removedMailDocument;
    }

    @Override
    public void close() {
        this.getIndex().close();
    }

    public String toString() {
        return this.getIdentifier() + " SimpleContainer";
    }

    @Override
    public IBox getBox(String boxName) throws ArchiveException {
        return this.boxGenerator.getBox(boxName);
    }

    @Override
    public Version getIndexVersion() {
        return this.getIndex().getVersion();
    }

    @Override
    public boolean isScidActive() {
        return this.isScidActive;
    }
}

