/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.utils;

import de.lwsystems.mailarchive.archive.box.INameIteratorStrategy;
import de.lwsystems.mailarchive.archive.box.MultiNameIteratorStrategy;
import de.lwsystems.mailarchive.config.RotationInterval;
import de.lwsystems.mailarchive.utils.Clock;
import de.lwsystems.mailarchive.utils.DateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.joda.time.DurationFieldType;

public class NameIteratorUtil {
    public static INameIteratorStrategy createNameIteratorStrategy(RotationInterval type) {
        INameIteratorStrategy strategy;
        switch (type) {
            case MINUTELY: {
                strategy = new MultiNameIteratorStrategy("yyyyMMddHHmm", DurationFieldType.minutes(), 1);
                break;
            }
            case MONTHLY: {
                strategy = new MultiNameIteratorStrategy("yyyyMM", DurationFieldType.months(), 1);
                break;
            }
            case QUARTERLY: {
                strategy = new MultiNameIteratorStrategy("yyyy", DurationFieldType.months(), 1){

                    @Override
                    public String getBoxNameForDate(Date date) {
                        String dateFormatted = super.getBoxNameForDate(date);
                        Calendar calendar = Clock.getProvider().getCalendarInstance(Locale.ROOT);
                        calendar.setTime(date);
                        return DateUtil.getQuartalString(dateFormatted, calendar);
                    }
                };
                break;
            }
            case SINGLE: {
                strategy = new INameIteratorStrategy(){

                    @Override
                    public String getBoxNameForDate(Date date) {
                        return null;
                    }

                    @Override
                    public Iterator<String> getIterator() {
                        return new Iterator<String>(){

                            @Override
                            public boolean hasNext() {
                                return false;
                            }

                            @Override
                            public String next() {
                                return null;
                            }

                            @Override
                            public void remove() {
                            }
                        };
                    }
                };
                break;
            }
            case DAILY: {
                strategy = new MultiNameIteratorStrategy("yyyyMMdd", DurationFieldType.days(), 1);
                break;
            }
            case WEEKLY: {
                strategy = new MultiNameIteratorStrategy("yyyy'w'ww", DurationFieldType.weeks(), 1);
                break;
            }
            case YEARLY: {
                strategy = new MultiNameIteratorStrategy("yyyy", DurationFieldType.months(), 1);
                break;
            }
            default: {
                throw new RuntimeException("bad config");
            }
        }
        return strategy;
    }
}

