/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.authentication.protocol;

import de.lwsystems.mailarchive.authentication.protocol.BennoAuthError;
import de.lwsystems.mailarchive.authentication.protocol.BennoAuthResult;
import java.util.ArrayList;
import java.util.List;

public class BennoAuthResultBuilder {
    private List<String> archives = new ArrayList<String>();
    private List<String> roles = new ArrayList<String>();
    private String displayName;
    private List<String> emails = new ArrayList<String>();
    private String userId;
    private boolean valid;
    private List<BennoAuthError> errors = new ArrayList<BennoAuthError>();
    private List<String> warnings = new ArrayList<String>();
    private String restUrl;
    private String restUser;
    private String restPassword;
    private boolean broken;

    public BennoAuthResultBuilder withArchive(String archive) {
        this.archives.add(archive);
        return this;
    }

    public BennoAuthResultBuilder withRole(String role) {
        this.roles.add(role);
        return this;
    }

    public BennoAuthResultBuilder withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public BennoAuthResultBuilder withEmail(String email) {
        this.emails.add(email);
        return this;
    }

    public BennoAuthResultBuilder withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public BennoAuthResultBuilder withValid(boolean valid) {
        this.valid = valid;
        return this;
    }

    public BennoAuthResultBuilder withBroken(boolean broken) {
        this.broken = broken;
        return this;
    }

    public BennoAuthResultBuilder withError(BennoAuthError error) {
        this.errors.add(error);
        return this;
    }

    public BennoAuthResultBuilder withWarning(String warning) {
        this.warnings.add(warning);
        return this;
    }

    public BennoAuthResultBuilder withRestUrl(String restUrl) {
        this.restUrl = restUrl;
        return this;
    }

    public BennoAuthResultBuilder withRestUser(String restUser) {
        this.restUser = restUser;
        return this;
    }

    public BennoAuthResultBuilder withRestPassword(String restPassword) {
        this.restPassword = restPassword;
        return this;
    }

    public BennoAuthResult createBennoAuthResult() {
        return new BennoAuthResult(this.archives, this.roles, this.displayName, this.emails, this.userId, this.valid, this.errors, this.warnings, this.restUrl, this.restUser, this.restPassword, this.broken);
    }
}

