/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.log;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public abstract class LogClass {
    protected Path logFilePath;
    protected Path logFileDirectory;
    protected String lineBreak = "\n";

    public boolean existsLogFile(String lfp, String tempFileName) {
        this.setLogFilePath(lfp, tempFileName);
        this.setLogFileDirectory(lfp);
        return Files.exists(this.logFilePath, new LinkOption[0]);
    }

    private void setLogFileDirectory(String lfp) {
        this.logFileDirectory = Paths.get(lfp, new String[0]);
    }

    private void setLogFilePath(String lfp, String tempFileName) {
        this.logFilePath = Paths.get(lfp + "/" + tempFileName, new String[0]);
    }

    public abstract void moveLogFile() throws IOException;

    public void createLogFile() throws IOException {
        if (!Files.exists(this.logFilePath, new LinkOption[0])) {
            Files.createFile(this.logFilePath, new FileAttribute[0]);
        }
    }

    protected void moveFile(Path newLogFilePath) throws IOException {
        Files.move(this.logFilePath, newLogFilePath, StandardCopyOption.REPLACE_EXISTING);
    }

    public abstract void addEntry(String ... var1) throws IOException;

    public Path getLogFilePath() {
        return this.logFilePath;
    }
}

