/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.tikaparser;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import net.sourceforge.tess4j.util.ImageHelper;

public class ImageUtils {
    public static BufferedImage deskew(BufferedImage image, double minAngle) {
        double deskewAngle = ImageUtils.getDeskewAngle(image);
        if (Math.abs(deskewAngle) < minAngle) {
            return image;
        }
        return ImageHelper.rotateImage((BufferedImage)image, (double)(-deskewAngle));
    }

    public static double getDeskewAngle(BufferedImage image) {
        BufferedImage black = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        Graphics2D g = black.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        double skewRadians = ImageUtils.findSkew(black);
        return skewRadians;
    }

    static int getByteWidth(int width) {
        return (width + 7) / 8;
    }

    static int next_pow2(int n) {
        int retval;
        for (retval = 1; retval < n; retval <<= 1) {
        }
        return retval;
    }

    static double findSkew(BufferedImage img) {
        DataBuffer buffer = img.getRaster().getDataBuffer();
        int byteWidth = ImageUtils.getByteWidth(img.getWidth());
        int padmask = 255 << (img.getWidth() + 7) % 8;
        int elementIndex = 0;
        for (int row = 0; row < img.getHeight(); ++row) {
            for (int col = 0; col < byteWidth; ++col) {
                int elem = buffer.getElem(elementIndex);
                elem ^= 0xFF;
                elem = BitUtils.invbits_[elem];
                buffer.setElem(elementIndex, elem);
                ++elementIndex;
            }
            int lastElement = buffer.getElem(elementIndex - 1) & padmask;
            buffer.setElem(elementIndex - 1, lastElement);
        }
        int w2 = ImageUtils.next_pow2(byteWidth);
        int ssize = 2 * w2 - 1;
        int[] sharpness = new int[ssize];
        ImageUtils.radon(img.getWidth(), img.getHeight(), buffer, 1, sharpness);
        ImageUtils.radon(img.getWidth(), img.getHeight(), buffer, -1, sharpness);
        int imax = 0;
        int vmax = 0;
        double sum = 0.0;
        for (int i = 0; i < ssize; ++i) {
            int s = sharpness[i];
            if (s > vmax) {
                imax = i;
                vmax = s;
            }
            sum += (double)s;
        }
        int h = img.getHeight();
        if ((double)vmax <= 3.0 * sum / (double)h) {
            return 0.0;
        }
        double iskew = imax - w2 + 1;
        return Math.atan(iskew / (double)(8 * w2));
    }

    static void radon(int width, int height, DataBuffer buffer, int sign, int[] sharpness) {
        int column;
        int row;
        int w2 = ImageUtils.next_pow2(ImageUtils.getByteWidth(width));
        int w = ImageUtils.getByteWidth(width);
        int h = height;
        int s = h * w2;
        int[] p1_ = new int[s];
        int[] p2_ = new int[s];
        int scanlinePosition = 0;
        for (row = 0; row < h; ++row) {
            scanlinePosition = row * w;
            for (column = 0; column < w; ++column) {
                int b;
                if (sign > 0) {
                    b = buffer.getElem(0, scanlinePosition + w - 1 - column);
                    p1_[h * column + row] = BitUtils.bitcount_[b];
                    continue;
                }
                b = buffer.getElem(0, scanlinePosition + column);
                p1_[h * column + row] = BitUtils.bitcount_[b];
            }
        }
        int[] x1 = p1_;
        int[] x2 = p2_;
        int step = 1;
        do {
            for (int i = 0; i < w2; i += 2 * step) {
                for (int j = 0; j < step; ++j) {
                    int s1 = h * (i + j);
                    int s2 = h * (i + j + step);
                    int t1 = h * (i + 2 * j);
                    int t2 = h * (i + 2 * j + 1);
                    for (int m = 0; m < h; ++m) {
                        x2[t1 + m] = x1[s1 + m];
                        x2[t2 + m] = x1[s1 + m];
                        if (m + j < h) {
                            int n = t1 + m;
                            x2[n] = x2[n] + x1[s2 + m + j];
                        }
                        if (m + j + 1 >= h) continue;
                        int n = t2 + m;
                        x2[n] = x2[n] + x1[s2 + m + j + 1];
                    }
                }
            }
            int[] aux = x1;
            x1 = x2;
            x2 = aux;
        } while ((step *= 2) < w2);
        for (column = 0; column < w2; ++column) {
            int acc = 0;
            int col = h * column;
            row = 0;
            while (row + 1 < h) {
                int diff = x1[col + row] - x1[col + row + 1];
                acc += diff * diff;
                ++row;
            }
            sharpness[w2 - 1 + sign * column] = acc;
        }
    }

    static class BitUtils {
        static int[] bitcount_ = new int[256];
        static int[] invbits_ = new int[256];

        BitUtils() {
        }

        static {
            for (int i = 0; i < 256; ++i) {
                int j = i;
                int cnt = 0;
                do {
                    cnt += j & 1;
                } while ((j >>= 1) != 0);
                int x = i << 4 | i >> 4;
                x = (x & 0xCC) >> 2 | (x & 0x33) << 2;
                x = (x & 0xAA) >> 1 | (x & 0x55) << 1;
                BitUtils.bitcount_[i] = cnt;
                BitUtils.invbits_[i] = x;
            }
        }
    }
}

