#!/bin/sh
# preinst script for benno-exchange
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <new-preinst> `install'
#        * <new-preinst> `install' <old-version>
#        * <new-preinst> `upgrade' <old-version>
#        * <old-preinst> `abort-upgrade' <new-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    install|upgrade)
        [ -z "$SERVER_HOME" ] && SERVER_HOME=/srv/benno
        [ -z "$SERVER_USER" ] && SERVER_USER=benno
        [ -z "$SERVER_GROUP" ] && SERVER_GROUP=benno
        [ -z "$SERVER_LOG" ] && SERVER_LOG=/var/log/benno
        [ -z "$SERVER_CACHE" ] && SERVER_CACHE=/var/cache/benno-archive

        test -d $SERVER_HOME || mkdir $SERVER_HOME

        if ! getent group | grep -q "^$SERVER_GROUP:" ; then
            echo -n "Adding group $SERVER_GROUP.."
            addgroup --quiet --system $SERVER_GROUP 2>/dev/null ||true
            echo "..done"
        fi
        if ! getent passwd | grep -q "^$SERVER_USER:"; then
            echo -n "Adding system user $SERVER_USER.."
            adduser --quiet --system --ingroup $SERVER_GROUP --no-create-home \
                    --home /srv/benno \
                    --disabled-password $SERVER_USER 2>/dev/null || true
            echo "..done"
        fi
    ;;

    abort-upgrade)
    ;;

    *)
        echo "preinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
