package Benno::Exchange2003;
use MIME::Parser;
use strict;

################################################################################
### Exchange2003::parse_journalmail($journal_message)
#
# Returns the message with X-REAL-MAILFROM and X-REAL-RCPTTO headers
#
#  -- parse_journalmail($journal_message)
#       |
#       +-- fetch_envelopes($metadata_part)
#             |
#             +-- unfold_header(\@lines)
#             |
#             +-- extract_envelope($headerline)
#
sub parse_journalmail
{
    my ($journal_msg) = @_;
    my $sender;
    my @recipients;

    my $Parser = new MIME::Parser;
    $Parser->output_to_core(1);
    $Parser->extract_nested_messages(0);
    my $Entity = $Parser->parse_data($journal_msg);

    # journal mail structure of Exchange 2003
    #
    # layer | type                      |
    # ------+---------------------------+----------------------------
    # 0     | multipart/mixed           |
    # 1     |     multipart/alternative |
    # 2     |         text/plain        | envelope information (text)
    # 2     |         text/html         | envelope information (html)
    # 1     |     message/rfc822        | original email

    # fetch part with metadata (layer 1)
    my $num;
    $num = $Entity->parts(0)->parts;
    for (my $i=0;$i<$num;$i++) {
        my $metadata_part = $Entity->parts(0)->parts($i);
        print "Type($i): ",$metadata_part->mime_type,"\n" if $main::DEBUG;
        # fetch envelope data from text/plain part
        next unless $metadata_part->mime_type =~ q{^text/plain};

        ($sender,@recipients) = fetch_envelopes($metadata_part);
        print "Sender: $sender\n" if $main::DEBUG;
        print "Recipient: @recipients\n" if $main::DEBUG;
    }
    unless ($sender || @recipients) {
        die "No sender information in metadata.";
    }

    return $Entity->parts(1)->stringify_body,$sender,@recipients;
}


### ($sender,@recipients) fetch_envelopes($mime_part)
#
# Returns the envelope data of the email
#
#
sub fetch_envelopes
{
    my ($entity) = @_;
    my $senderline;
    my $recipientsline;

    my @lines = $entity->bodyhandle->as_lines;
    while (my $line = shift @lines) {
        if ($line =~ /^Sender:/) {
            chomp $line;
            $senderline = $line;
            $senderline .= unfold_header(\@lines);
        }
        if ($line =~ /^Recipients:/) {
            chomp $line;
            $recipientsline = $line;
            $recipientsline .= unfold_header(\@lines);
        }
    }

    my ($sender) = extract_envelope($senderline);
    my (@recipients) = extract_envelope($recipientsline);

    return $sender,@recipients;
}


### ($headerline) unfold_header(@header_lines)
#
# Returns the unfolded header line
#
sub unfold_header
{
    my $lines = shift;

    my $line;
    if ($lines->[0] =~ /^\s+/) {
        $line = shift @{$lines};
        chomp $line;
        $line .= unfold_header($lines);
    }

    return $line;
}


### (@envelopes) extract_envelope($headerline)
#
# Returns an array with envelope adresses
#
sub extract_envelope
{
    my $metaline = shift;

    my @envelopes;
    foreach my $token (split /\s+/, $metaline) {
        next if $token !~ /\<\S+\@\S+\>/;
        $token =~ s/\<(\S+)\>/$1/;
        $token =~ s/^smtp://i;
        $token =~ s/,$//i;
        push @envelopes,$token;
    }

    return @envelopes;
}


### EOP ###
1;



