/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.tokenizer.DetokenizationDictionaryLoader;
import opennlp.tools.tokenize.DetokenizationDictionary;
import opennlp.tools.tokenize.DictionaryDetokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.PlainTextByLineStream;

public final class DictionaryDetokenizerTool
extends BasicCmdLineTool {
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " detokenizerDictionary";
    }

    public void run(String[] args) {
        if (args.length != 1) {
            System.out.println(this.getHelp());
        } else {
            DictionaryDetokenizer detokenizer = new DictionaryDetokenizer((DetokenizationDictionary)new DetokenizationDictionaryLoader().load(new File(args[0])));
            PlainTextByLineStream tokenizedLineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
            PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "sent");
            perfMon.start();
            try {
                String tokenizedLine;
                while ((tokenizedLine = (String)tokenizedLineStream.read()) != null) {
                    String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(tokenizedLine);
                    System.out.println(detokenizer.detokenize(tokens, null));
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

