/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collections;
import java.util.Map;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.util.Static;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public final class Legacy
extends Static {
    private static final CartesianCS LEGACY = new DefaultCartesianCS((Map<String, ?>)Collections.singletonMap("name", "Legacy geocentric"), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Collections.singletonMap("name", "X"), "X", AxisDirection.OTHER, (Unit<?>)SI.METRE), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Collections.singletonMap("name", "Y"), "Y", AxisDirection.EAST, (Unit<?>)SI.METRE), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Collections.singletonMap("name", "Z"), "Z", AxisDirection.NORTH, (Unit<?>)SI.METRE));

    private Legacy() {
    }

    private static CartesianCS standard() {
        return (CartesianCS)CommonCRS.WGS84.geocentric().getCoordinateSystem();
    }

    public static CartesianCS forGeocentricCRS(CartesianCS cartesianCS, boolean bl) {
        CartesianCS cartesianCS2 = bl ? Legacy.standard() : LEGACY;
        int n = cartesianCS2.getDimension();
        if (cartesianCS.getDimension() != n) {
            return cartesianCS;
        }
        for (int i = 0; i < n; ++i) {
            if (cartesianCS.getAxis(i).getDirection().equals(cartesianCS2.getAxis(i).getDirection())) continue;
            return cartesianCS;
        }
        return bl ? LEGACY : Legacy.standard();
    }
}

