/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.StringBuilders;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.CodeList;

public final class VerticalDatumTypes
implements CodeList.Filter {
    public static final VerticalDatumType ELLIPSOIDAL = VerticalDatumType.valueOf("ELLIPSOIDAL");
    public static final VerticalDatumType ORTHOMETRIC = VerticalDatumType.valueOf("ORTHOMETRIC");
    private static final VerticalDatumType[] TYPES = new VerticalDatumType[7];
    private static final short[] LEGACY_CODES = new short[Math.max(ELLIPSOIDAL.ordinal(), ORTHOMETRIC.ordinal()) + 1];
    private final StringBuilder datum;

    public static VerticalDatumType fromLegacy(int n) {
        return (n -= 2000) >= 0 && n < TYPES.length ? TYPES[n] : null;
    }

    public static int toLegacy(int n) {
        return n >= 0 && n < LEGACY_CODES.length ? LEGACY_CODES[n] : 0;
    }

    public static VerticalDatumType guess(VerticalDatum verticalDatum) {
        VerticalDatumType verticalDatumType = CodeList.valueOf(VerticalDatumType.class, new VerticalDatumTypes(IdentifiedObjects.getName(verticalDatum, null)));
        return verticalDatumType != null ? verticalDatumType : VerticalDatumType.OTHER_SURFACE;
    }

    private VerticalDatumTypes(String string) {
        int n;
        int n2 = string.length();
        this.datum = new StringBuilder(n2);
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            this.datum.appendCodePoint(Character.toUpperCase(n));
        }
        StringBuilders.toASCII(this.datum);
    }

    @Override
    public boolean accept(CodeList<?> codeList) {
        int n = this.datum.indexOf(codeList.name());
        return n == 0 || n >= 0 && Character.isWhitespace(this.datum.codePointBefore(n));
    }

    @Override
    public String codename() {
        return null;
    }

    static {
        block8: for (int n = 2000; n <= 2006; n = (int)((short)(n + 1))) {
            VerticalDatumType verticalDatumType;
            switch (n) {
                case 2000: {
                    verticalDatumType = VerticalDatumType.OTHER_SURFACE;
                    break;
                }
                case 2001: {
                    verticalDatumType = ORTHOMETRIC;
                    break;
                }
                case 2002: {
                    verticalDatumType = ELLIPSOIDAL;
                    break;
                }
                case 2003: {
                    verticalDatumType = VerticalDatumType.BAROMETRIC;
                    break;
                }
                case 2005: {
                    verticalDatumType = VerticalDatumType.GEOIDAL;
                    break;
                }
                case 2006: {
                    verticalDatumType = VerticalDatumType.DEPTH;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            VerticalDatumTypes.TYPES[n - 2000] = verticalDatumType;
            VerticalDatumTypes.LEGACY_CODES[verticalDatumType.ordinal()] = n;
        }
    }
}

