/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.parameter.AbstractParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public class DefaultParameterDescriptorGroup
extends AbstractParameterDescriptor
implements ParameterDescriptorGroup {
    private static final long serialVersionUID = 6058599597772994456L;
    private final List<GeneralParameterDescriptor> descriptors;

    public DefaultParameterDescriptorGroup(Map<String, ?> map, int n, int n2, GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        super(map, n, n2);
        ArgumentChecks.ensureNonNull("parameters", generalParameterDescriptorArray);
        generalParameterDescriptorArray = (GeneralParameterDescriptor[])generalParameterDescriptorArray.clone();
        for (int i = 0; i < generalParameterDescriptorArray.length; ++i) {
            ArgumentChecks.ensureNonNullElement("parameters", i, generalParameterDescriptorArray);
            String string = generalParameterDescriptorArray[i].getName().getCode();
            for (int j = 0; j < i; ++j) {
                if (!IdentifiedObjects.isHeuristicMatchForName(generalParameterDescriptorArray[j], string)) continue;
                throw new InvalidParameterNameException(Errors.getResources(map).getString((short)150, generalParameterDescriptorArray[j].getName().getCode(), j, string, i), string);
            }
        }
        this.descriptors = DefaultParameterDescriptorGroup.asList(generalParameterDescriptorArray);
    }

    protected DefaultParameterDescriptorGroup(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
        List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
        this.descriptors = parameterDescriptorGroup instanceof DefaultParameterDescriptorGroup && ((DefaultParameterDescriptorGroup)parameterDescriptorGroup).descriptors == list ? list : DefaultParameterDescriptorGroup.asList(list.toArray(new GeneralParameterDescriptor[list.size()]));
    }

    private static List<GeneralParameterDescriptor> asList(GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        switch (generalParameterDescriptorArray.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(generalParameterDescriptorArray[0]);
            }
            case 2: 
            case 3: {
                return UnmodifiableArrayList.wrap(generalParameterDescriptorArray);
            }
        }
        return new AsList(generalParameterDescriptorArray);
    }

    public static DefaultParameterDescriptorGroup castOrCopy(ParameterDescriptorGroup parameterDescriptorGroup) {
        return parameterDescriptorGroup == null || parameterDescriptorGroup instanceof DefaultParameterDescriptorGroup ? (DefaultParameterDescriptorGroup)parameterDescriptorGroup : new DefaultParameterDescriptorGroup(parameterDescriptorGroup);
    }

    public Class<? extends ParameterDescriptorGroup> getInterface() {
        return ParameterDescriptorGroup.class;
    }

    @Override
    public List<GeneralParameterDescriptor> descriptors() {
        return this.descriptors;
    }

    @Override
    public GeneralParameterDescriptor descriptor(String string) throws ParameterNotFoundException {
        GeneralParameterDescriptor generalParameterDescriptor2;
        ArgumentChecks.ensureNonNull("name", string);
        for (GeneralParameterDescriptor generalParameterDescriptor2 : this.descriptors) {
            if (!string.equals(generalParameterDescriptor2.getName().getCode())) continue;
            return generalParameterDescriptor2;
        }
        Object object = null;
        generalParameterDescriptor2 = null;
        for (GeneralParameterDescriptor generalParameterDescriptor3 : this.descriptors) {
            if (!IdentifiedObjects.isHeuristicMatchForName(generalParameterDescriptor3, string)) continue;
            if (object == null) {
                object = generalParameterDescriptor3;
                continue;
            }
            generalParameterDescriptor2 = generalParameterDescriptor3;
        }
        if (object != null && generalParameterDescriptor2 == null) {
            return object;
        }
        throw new ParameterNotFoundException(generalParameterDescriptor2 != null ? Errors.format((short)151, object.getName(), generalParameterDescriptor2.getName(), string) : Errors.format((short)147, this.getName(), string), string);
    }

    @Override
    public ParameterValueGroup createValue() {
        return new DefaultParameterValueGroup(this);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    return this.descriptors.equals(((DefaultParameterDescriptorGroup)object).descriptors);
                }
            }
            return Utilities.deepEquals(this.descriptors(), ((ParameterDescriptorGroup)object).descriptors(), comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)this.descriptors.hashCode();
    }

    private static final class AsList
    extends UnmodifiableArrayList<GeneralParameterDescriptor> {
        private static final long serialVersionUID = -2116304004367396735L;
        private volatile transient Set<GeneralParameterDescriptor> asSet;

        public AsList(GeneralParameterDescriptor[] generalParameterDescriptorArray) {
            super(generalParameterDescriptorArray);
        }

        @Override
        public boolean contains(Object object) {
            Set<GeneralParameterDescriptor> set = this.asSet;
            if (set == null) {
                this.asSet = set = new HashSet<GeneralParameterDescriptor>(this);
            }
            return set.contains(object);
        }
    }
}

