/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.parameter.ParameterFormat;
import org.apache.sis.parameter.ParameterValueList;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

public class DefaultParameterValueGroup
implements ParameterValueGroup,
LenientComparable,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1985309386356545126L;
    private ParameterValueList values;

    public DefaultParameterValueGroup(ParameterDescriptorGroup parameterDescriptorGroup) {
        ArgumentChecks.ensureNonNull("descriptor", parameterDescriptorGroup);
        this.values = new ParameterValueList(parameterDescriptorGroup);
    }

    @Override
    public ParameterDescriptorGroup getDescriptor() {
        return this.values.descriptor;
    }

    @Override
    public List<GeneralParameterValue> values() {
        return this.values;
    }

    @Override
    public ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        Object object;
        int n;
        ArgumentChecks.ensureNonNull("name", string);
        ParameterValueList parameterValueList = this.values;
        int n2 = parameterValueList.size();
        for (n = 0; n < n2; ++n) {
            GeneralParameterDescriptor generalParameterDescriptor = parameterValueList.descriptor(n);
            if (!(generalParameterDescriptor instanceof ParameterDescriptor) || !string.equals(generalParameterDescriptor.getName().toString())) continue;
            return (ParameterValue)parameterValueList.get(n);
        }
        n = -1;
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            object = parameterValueList.descriptor(i);
            if (!(object instanceof ParameterDescriptor) || !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)object, string)) continue;
            if (n < 0) {
                n = i;
                continue;
            }
            n3 = i;
        }
        if (n >= 0) {
            if (n3 < 0) {
                return (ParameterValue)parameterValueList.get(n);
            }
            throw new ParameterNotFoundException(Errors.format((short)151, parameterValueList.descriptor(n).getName(), parameterValueList.descriptor(n3).getName(), string), string);
        }
        GeneralParameterDescriptor generalParameterDescriptor = parameterValueList.descriptor.descriptor(string);
        if (generalParameterDescriptor instanceof ParameterDescriptor && generalParameterDescriptor.getMaximumOccurs() != 0) {
            object = ((ParameterDescriptor)generalParameterDescriptor).createValue();
            parameterValueList.addUnchecked((GeneralParameterValue)object);
            return object;
        }
        throw new ParameterNotFoundException(Errors.format((short)147, parameterValueList.descriptor.getName(), string), string);
    }

    @Override
    public List<ParameterValueGroup> groups(String string) throws ParameterNotFoundException {
        ParameterDescriptorGroup parameterDescriptorGroup;
        ArgumentChecks.ensureNonNull("name", string);
        ParameterValueList parameterValueList = this.values;
        ArrayList<ParameterValueGroup> arrayList = new ArrayList<ParameterValueGroup>(4);
        int n = parameterValueList.size();
        for (int i = 0; i < n; ++i) {
            GeneralParameterDescriptor generalParameterDescriptor = parameterValueList.descriptor(i);
            if (!(generalParameterDescriptor instanceof ParameterDescriptorGroup) || !IdentifiedObjects.isHeuristicMatchForName(generalParameterDescriptor, string)) continue;
            arrayList.add((ParameterValueGroup)parameterValueList.get(i));
        }
        if (arrayList.isEmpty() && !((parameterDescriptorGroup = parameterValueList.descriptor).descriptor(string) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format((short)147, parameterDescriptorGroup.getName(), string), string);
        }
        return arrayList;
    }

    @Override
    public ParameterValueGroup addGroup(String string) throws ParameterNotFoundException, InvalidParameterCardinalityException {
        ParameterValueList parameterValueList = this.values;
        ParameterDescriptorGroup parameterDescriptorGroup = parameterValueList.descriptor;
        GeneralParameterDescriptor generalParameterDescriptor = parameterDescriptorGroup.descriptor(string);
        if (!(generalParameterDescriptor instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format((short)147, parameterDescriptorGroup.getName(), string), string);
        }
        ParameterValueGroup parameterValueGroup = ((ParameterDescriptorGroup)generalParameterDescriptor).createValue();
        parameterValueList.add(parameterValueGroup);
        return parameterValueGroup;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (comparisonMode == ComparisonMode.STRICT) {
                if (this.getClass() == object.getClass()) {
                    DefaultParameterValueGroup defaultParameterValueGroup = (DefaultParameterValueGroup)object;
                    return Objects.equals(this.values.descriptor, defaultParameterValueGroup.values.descriptor) && Objects.equals(this.values, defaultParameterValueGroup.values);
                }
            } else if (object instanceof ParameterValueGroup) {
                ParameterValueGroup parameterValueGroup = (ParameterValueGroup)object;
                return Utilities.deepEquals(this.getDescriptor(), parameterValueGroup.getDescriptor(), comparisonMode) && Utilities.deepEquals(this.values(), parameterValueGroup.values(), comparisonMode);
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        return this.values.descriptor.hashCode() ^ this.values.hashCode();
    }

    @Override
    public DefaultParameterValueGroup clone() {
        DefaultParameterValueGroup defaultParameterValueGroup;
        try {
            defaultParameterValueGroup = (DefaultParameterValueGroup)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        defaultParameterValueGroup.values = new ParameterValueList(defaultParameterValueGroup.values);
        return defaultParameterValueGroup;
    }

    public String toString() {
        return ParameterFormat.sharedFormat(this);
    }

    public void print() {
        ParameterFormat.print(this);
    }
}

