/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;

final class Verifier {
    private final short errorKey;
    private final boolean needsValue;
    private final Object[] arguments;

    private Verifier(short s, boolean bl, Object ... objectArray) {
        this.errorKey = s;
        this.needsValue = bl;
        this.arguments = objectArray;
    }

    static <T> T ensureValidValue(ParameterDescriptor<T> parameterDescriptor, Object object, Unit<?> unit) throws InvalidParameterValueException {
        Class<?> clazz;
        Object object2;
        Class<T> clazz2 = parameterDescriptor.getValueClass();
        UnitConverter unitConverter = null;
        Object object3 = object;
        if (unit != null) {
            object2 = parameterDescriptor.getUnit();
            if (object2 == null) {
                String string = Verifier.getName(parameterDescriptor);
                throw new InvalidParameterValueException(Errors.format((short)139, string), string, unit);
            }
            if (!unit.equals(object2)) {
                short s = Verifier.getUnitMessageID(object2);
                if (Verifier.getUnitMessageID(unit) != s) {
                    throw new IllegalArgumentException(Errors.format(s, unit));
                }
                if (object != null) {
                    if (!clazz2.isInstance(object)) {
                        String string = Verifier.getName(parameterDescriptor);
                        throw new InvalidParameterValueException(Errors.format((short)138, string, clazz2, object.getClass()), string, object);
                    }
                    try {
                        unitConverter = unit.getConverterToAny((Unit)object2);
                    }
                    catch (ConversionException conversionException) {
                        throw new IllegalArgumentException(Errors.format((short)46, unit, object2), conversionException);
                    }
                    clazz = clazz2.getComponentType();
                    if (clazz == null) {
                        Double d = unitConverter.convert(((Number)object).doubleValue());
                        try {
                            object3 = Numbers.cast(d, clazz2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new InvalidParameterValueException(illegalArgumentException.getLocalizedMessage(), Verifier.getName(parameterDescriptor), object);
                        }
                    }
                    int n = Array.getLength(object);
                    object3 = Array.newInstance(clazz, n);
                    clazz = Numbers.primitiveToWrapper(clazz);
                    for (int i = 0; i < n; ++i) {
                        Number number = (Number)Array.get(object, i);
                        number = unitConverter.convert(number.doubleValue());
                        try {
                            number = Numbers.cast(number, clazz);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new InvalidParameterValueException(illegalArgumentException.getLocalizedMessage(), Verifier.getName(parameterDescriptor) + '[' + i + ']', object);
                        }
                        Array.set(object3, i, number);
                    }
                }
            }
        }
        if (object3 != null) {
            Set<T> set = parameterDescriptor.getValidValues();
            object2 = parameterDescriptor instanceof DefaultParameterDescriptor ? Verifier.ensureValidValue(clazz2, set, ((DefaultParameterDescriptor)parameterDescriptor).getValueDomain(), object3) : Verifier.ensureValidValue(clazz2, set, parameterDescriptor.getMinimumValue(), parameterDescriptor.getMaximumValue(), object3);
            if (object2 != null) {
                super.convertRange(unitConverter);
                clazz = Verifier.getName(parameterDescriptor);
                throw new InvalidParameterValueException(((Verifier)object2).message(null, (String)((Object)clazz), object), (String)((Object)clazz), object);
            }
        }
        return (T)object3;
    }

    static <T> Verifier ensureValidValue(Class<T> clazz, Set<T> set, Range<?> range, Object object) {
        Verifier verifier = Verifier.ensureValidValue(clazz, set, null, null, object);
        if (verifier == null && range != null) {
            if (!clazz.isArray()) {
                assert (range.getElementType() == clazz) : range;
                if (!range.contains((Comparable)object)) {
                    return new Verifier(133, true, null, range.getMinValue(), range.getMaxValue(), object);
                }
            } else {
                assert (range.getElementType() == Numbers.primitiveToWrapper(clazz.getComponentType())) : range;
                int n = Array.getLength(object);
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    if (range.contains((Comparable)object2)) continue;
                    return new Verifier(133, true, i, range.getMinValue(), range.getMaxValue(), object2);
                }
            }
        }
        return verifier;
    }

    private static <T> Verifier ensureValidValue(Class<T> clazz, Set<T> set, Comparable<T> comparable, Comparable<T> comparable2, Object object) {
        if (!clazz.isInstance(object)) {
            return new Verifier(138, false, null, clazz, object.getClass());
        }
        if (set != null && !set.contains(object)) {
            return new Verifier(144, true, null, object);
        }
        if (comparable != null && comparable.compareTo(object) > 0 || comparable2 != null && comparable2.compareTo(object) < 0) {
            return new Verifier(133, true, null, comparable, comparable2, object);
        }
        return null;
    }

    private void convertRange(UnitConverter unitConverter) {
        if (unitConverter != null && this.errorKey == 133) {
            unitConverter = unitConverter.inverse();
            Object object = this.arguments[1];
            Object object2 = this.arguments[2];
            object = object != null ? Double.valueOf(unitConverter.convert(((Number)object).doubleValue())) : "-\u221e";
            object2 = object2 != null ? Double.valueOf(unitConverter.convert(((Number)object2).doubleValue())) : "\u221e";
            this.arguments[1] = object;
            this.arguments[2] = object2;
        }
    }

    String message(Map<?, ?> map, String string, Object object) {
        Object object2 = this.arguments[0];
        if (object2 != null) {
            string = string + '[' + object2 + ']';
            object = Array.get(object, (Integer)object2);
        }
        this.arguments[0] = string;
        if (this.needsValue) {
            this.arguments[this.arguments.length - 1] = object;
        }
        return Errors.getResources(map).getString(this.errorKey, this.arguments);
    }

    static String getName(GeneralParameterDescriptor generalParameterDescriptor) {
        return generalParameterDescriptor.getName().getCode();
    }

    static short getUnitMessageID(Unit<?> unit) {
        if (Units.isLinear(unit)) {
            return 84;
        }
        if (Units.isAngular(unit)) {
            return 78;
        }
        if (Units.isTemporal(unit)) {
            return 87;
        }
        if (Units.isScale(unit)) {
            return 86;
        }
        return 140;
    }
}

