/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

public class NamedIdentifier
extends ImmutableIdentifier
implements GenericName {
    private static final long serialVersionUID = -3982456534858346939L;
    private static final Map<CharSequence, NameSpace> SCOPES = new WeakValueHashMap<CharSequence, NameSpace>(CharSequence.class);
    private transient GenericName name;
    private transient boolean isNameSupplied;

    public NamedIdentifier(ReferenceIdentifier referenceIdentifier) {
        super(referenceIdentifier);
        if (referenceIdentifier instanceof GenericName) {
            this.name = (GenericName)((Object)referenceIdentifier);
            this.isNameSupplied = true;
        }
    }

    public NamedIdentifier(GenericName genericName) {
        super(genericName instanceof ReferenceIdentifier ? (ReferenceIdentifier)((Object)genericName) : new NameToIdentifier(genericName));
        this.name = genericName;
        this.isNameSupplied = true;
    }

    public NamedIdentifier(Map<String, ?> map) throws IllegalArgumentException {
        super(map);
    }

    public NamedIdentifier(Citation citation, InternationalString internationalString) {
        this(citation, internationalString.toString(Locale.ROOT));
        this.name = this.createName(citation, internationalString);
        this.isNameSupplied = true;
    }

    public NamedIdentifier(Citation citation, String string) {
        super(citation, Citations.getIdentifier(citation), string);
    }

    public NamedIdentifier(Citation citation, String string, String string2, String string3, InternationalString internationalString) {
        super(citation, string, string2, string3, internationalString);
    }

    private synchronized GenericName getName() {
        if (this.name == null) {
            this.name = this.createName(super.getAuthority(), super.getCode());
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericName createName(Citation citation, CharSequence charSequence) {
        Object object;
        DefaultNameFactory defaultNameFactory = DefaultFactories.NAMES;
        String string = Citations.getIdentifier(citation);
        NameSpace nameSpace = null;
        if (string != null) {
            object = SCOPES;
            synchronized (object) {
                nameSpace = SCOPES.get(string);
                if (nameSpace == null) {
                    nameSpace = defaultNameFactory.createNameSpace(defaultNameFactory.createLocalName(null, string), null);
                    SCOPES.put(string, nameSpace);
                }
            }
        }
        if ((object = super.getCodeSpace()) != null) {
            return defaultNameFactory.createGenericName(nameSpace, new CharSequence[]{object, charSequence});
        }
        return defaultNameFactory.createLocalName(nameSpace, charSequence);
    }

    @Override
    public LocalName tip() {
        return this.getName().tip();
    }

    @Override
    public LocalName head() {
        return this.getName().head();
    }

    @Override
    public NameSpace scope() {
        return this.getName().scope();
    }

    @Override
    public int depth() {
        return this.getName().depth();
    }

    @Override
    public List<? extends LocalName> getParsedNames() {
        return this.getName().getParsedNames();
    }

    @Override
    public ScopedName push(GenericName genericName) {
        return this.getName().push(genericName);
    }

    @Override
    public GenericName toFullyQualifiedName() {
        return this.getName().toFullyQualifiedName();
    }

    @Override
    public InternationalString toInternationalString() {
        return this.getName().toInternationalString();
    }

    @Override
    public String toString() {
        return this.getName().toString();
    }

    @Override
    public int compareTo(GenericName genericName) {
        return this.getName().compareTo(genericName);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            if (!this.isNameSupplied) {
                return true;
            }
            NamedIdentifier namedIdentifier = (NamedIdentifier)object;
            return Objects.equals(this.getName(), namedIdentifier.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ~super.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.isNameSupplied ? this.name : null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.name = (GenericName)objectInputStream.readObject();
        this.isNameSupplied = this.name != null;
    }
}

