/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import javax.measure.converter.ConversionException;
import javax.measure.converter.LinearConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.ElevationAngle;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Matrix;

public final class CoordinateSystems
extends Static {
    private CoordinateSystems() {
    }

    public static AxisDirection parseAxisDirection(String string) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("name", string);
        string = CharSequences.trimWhitespaces(string);
        AxisDirection axisDirection = AxisDirections.valueOf(string);
        if (axisDirection != null) {
            return axisDirection;
        }
        DirectionAlongMeridian directionAlongMeridian = DirectionAlongMeridian.parse(string);
        if (directionAlongMeridian != null) {
            axisDirection = directionAlongMeridian.getDirection();
            assert (axisDirection == AxisDirections.valueOf(directionAlongMeridian.toString()));
            return axisDirection;
        }
        throw new IllegalArgumentException(Errors.format((short)112, string));
    }

    public static Angle angle(AxisDirection axisDirection, AxisDirection axisDirection2) {
        DirectionAlongMeridian directionAlongMeridian;
        ArgumentChecks.ensureNonNull("source", axisDirection);
        ArgumentChecks.ensureNonNull("target", axisDirection2);
        int n = AxisDirections.angleForCompass(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new Angle((double)n * 22.5);
        }
        n = AxisDirections.angleForGeocentric(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new Angle(n * 90);
        }
        n = AxisDirections.angleForDisplay(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new Angle(n * 90);
        }
        DirectionAlongMeridian directionAlongMeridian2 = AxisDirections.isUserDefined(axisDirection) ? DirectionAlongMeridian.parse(axisDirection) : null;
        DirectionAlongMeridian directionAlongMeridian3 = directionAlongMeridian = AxisDirections.isUserDefined(axisDirection2) ? DirectionAlongMeridian.parse(axisDirection2) : null;
        if (directionAlongMeridian2 != null && directionAlongMeridian != null) {
            return new Angle(directionAlongMeridian2.angle(directionAlongMeridian));
        }
        boolean bl = AxisDirections.isVertical(axisDirection);
        boolean bl2 = AxisDirections.isVertical(axisDirection2);
        if (bl2) {
            if (bl) {
                return new Angle(axisDirection.equals(axisDirection2) ? 0.0 : (axisDirection2.equals(AxisDirection.UP) ? 180.0 : -180.0));
            }
            if (AxisDirections.isCompass(axisDirection) || directionAlongMeridian2 != null) {
                return axisDirection2.equals(AxisDirection.UP) ? ElevationAngle.ZENITH : ElevationAngle.NADIR;
            }
        } else if (bl && (AxisDirections.isCompass(axisDirection2) || directionAlongMeridian != null)) {
            return axisDirection.equals(AxisDirection.UP) ? ElevationAngle.NADIR : ElevationAngle.ZENITH;
        }
        return null;
    }

    private static AxisDirection[] getAxisDirections(CoordinateSystem coordinateSystem) {
        AxisDirection[] axisDirectionArray = new AxisDirection[coordinateSystem.getDimension()];
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            axisDirectionArray[i] = coordinateSystem.getAxis(i).getDirection();
        }
        return axisDirectionArray;
    }

    public static Matrix swapAndScaleAxes(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) throws IllegalArgumentException, ConversionException {
        if (!Classes.implementSameInterfaces(coordinateSystem.getClass(), coordinateSystem2.getClass(), CoordinateSystem.class)) {
            throw new IllegalArgumentException(Errors.format((short)44));
        }
        Object[] objectArray = CoordinateSystems.getAxisDirections(coordinateSystem);
        Object[] objectArray2 = CoordinateSystems.getAxisDirections(coordinateSystem2);
        MatrixSIS matrixSIS = Matrices.createTransform((AxisDirection[])objectArray, (AxisDirection[])objectArray2);
        assert (Arrays.equals(objectArray, objectArray2) == matrixSIS.isIdentity()) : matrixSIS;
        int n = matrixSIS.getNumCol() - 1;
        int n2 = matrixSIS.getNumRow() - 1;
        for (int i = 0; i < n2; ++i) {
            Unit<?> unit = coordinateSystem2.getAxis(i).getUnit();
            for (int j = 0; j < n; ++j) {
                Unit<?> unit2;
                double d = matrixSIS.getElement(i, j);
                if (d == 0.0 || Objects.equals(unit2 = coordinateSystem.getAxis(j).getUnit(), unit)) continue;
                UnitConverter unitConverter = unit2.getConverterToAny(unit);
                if (!(unitConverter instanceof LinearConverter)) {
                    throw new ConversionException(Errors.format((short)83, unit2, unit));
                }
                double d2 = unitConverter.convert(0.0);
                double d3 = Units.derivative(unitConverter, 0.0);
                matrixSIS.setElement(i, j, d * d3);
                matrixSIS.setElement(i, n, matrixSIS.getElement(i, n) + d * d2);
            }
        }
        return matrixSIS;
    }
}

