/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;

@XmlType(name="EllipsoidalCSType")
@XmlRootElement(name="EllipsoidalCS")
public class DefaultEllipsoidalCS
extends AbstractCS
implements EllipsoidalCS {
    private static final long serialVersionUID = -1452492488902329211L;

    private DefaultEllipsoidalCS() {
    }

    private DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
    }

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2);
        for (int i = 0; i < 2; ++i) {
            AxisDirection axisDirection = super.getAxis(i).getDirection();
            if (!AxisDirections.isVertical(axisDirection)) continue;
            throw new IllegalArgumentException(Errors.format((short)32, "EllipdoicalCS (2D)", axisDirection));
        }
    }

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
    }

    protected DefaultEllipsoidalCS(EllipsoidalCS ellipsoidalCS) {
        super(ellipsoidalCS);
    }

    public static DefaultEllipsoidalCS castOrCopy(EllipsoidalCS ellipsoidalCS) {
        return ellipsoidalCS == null || ellipsoidalCS instanceof DefaultEllipsoidalCS ? (DefaultEllipsoidalCS)ellipsoidalCS : new DefaultEllipsoidalCS(ellipsoidalCS);
    }

    @Override
    final int validateAxis(AxisDirection axisDirection, Unit<?> unit) {
        boolean bl = AxisDirection.UP.equals(axisDirection = AxisDirections.absolute(axisDirection));
        if (!(bl || AxisDirection.NORTH.equals(axisDirection) || AxisDirection.EAST.equals(axisDirection))) {
            return 1;
        }
        if (!(!bl ? Units.isAngular(unit) : Units.isLinear(unit))) {
            return 2;
        }
        return 0;
    }

    public Class<? extends EllipsoidalCS> getInterface() {
        return EllipsoidalCS.class;
    }

    @Override
    public DefaultEllipsoidalCS forConvention(AxesConvention axesConvention) {
        return (DefaultEllipsoidalCS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCS createSameType(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        return new DefaultEllipsoidalCS(map, coordinateSystemAxisArray);
    }
}

