/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.measure.unit.NonSI;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Longitude;
import org.apache.sis.util.iso.Types;
import org.opengis.referencing.cs.AxisDirection;

final class DirectionAlongMeridian
extends FormattableObject
implements Comparable<DirectionAlongMeridian> {
    private static final Pattern EPSG = Pattern.compile("(\\p{Graph}+)\\s+along\\s+([\\-\\p{Digit}\\.]+)(?:\\s+deg|\\s*\u00b0)\\s*(\\p{Graph}+)?", 2);
    private static final AxisDirection[] BASE_DIRECTIONS = new AxisDirection[]{AxisDirection.NORTH, AxisDirection.SOUTH, AxisDirection.EAST, AxisDirection.WEST};
    private transient AxisDirection direction;
    public final AxisDirection baseDirection;
    public final double meridian;

    private DirectionAlongMeridian(AxisDirection axisDirection, double d) {
        this.baseDirection = axisDirection;
        this.meridian = d;
    }

    public static DirectionAlongMeridian parse(AxisDirection axisDirection) {
        DirectionAlongMeridian directionAlongMeridian = DirectionAlongMeridian.parse(axisDirection.name());
        if (directionAlongMeridian != null) {
            directionAlongMeridian.direction = axisDirection;
        }
        return directionAlongMeridian;
    }

    public static DirectionAlongMeridian parse(String string) {
        double d;
        Matcher matcher = EPSG.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        AxisDirection axisDirection = AxisDirections.find(string2, BASE_DIRECTIONS);
        if (axisDirection == null || !AxisDirection.NORTH.equals(AxisDirections.absolute(axisDirection))) {
            return null;
        }
        string2 = matcher.group(2);
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (!(d >= -180.0) || !(d <= 180.0)) {
            return null;
        }
        string2 = matcher.group(3);
        if (string2 != null) {
            AxisDirection axisDirection2 = AxisDirections.find(string2, BASE_DIRECTIONS);
            if (axisDirection2 == null) {
                return null;
            }
            AxisDirection axisDirection3 = AxisDirections.absolute(axisDirection2);
            if (!AxisDirection.EAST.equals(axisDirection3)) {
                return null;
            }
            if (axisDirection2 != axisDirection3) {
                d = -d;
            }
        }
        return new DirectionAlongMeridian(axisDirection, d);
    }

    public AxisDirection getDirection() {
        if (this.direction == null) {
            String string = this.toString();
            this.direction = AxisDirections.valueOf(string);
            if (this.direction == null) {
                this.direction = Types.forCodeName(AxisDirection.class, string, true);
            }
        }
        return this.direction;
    }

    public double angle(DirectionAlongMeridian directionAlongMeridian) {
        if (!this.baseDirection.equals(directionAlongMeridian.baseDirection)) {
            return Double.NaN;
        }
        double d = Longitude.normalize(this.meridian - directionAlongMeridian.meridian);
        if (AxisDirections.isOpposite(this.baseDirection)) {
            d = -d;
        }
        return d;
    }

    @Override
    public int compareTo(DirectionAlongMeridian directionAlongMeridian) {
        int n = this.baseDirection.compareTo(directionAlongMeridian.baseDirection);
        if (n != 0) {
            return n;
        }
        double d = this.angle(directionAlongMeridian);
        if (d < 0.0) {
            return 1;
        }
        if (d > 0.0) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof DirectionAlongMeridian) {
            DirectionAlongMeridian directionAlongMeridian = (DirectionAlongMeridian)object;
            return this.baseDirection.equals(directionAlongMeridian.baseDirection) && Numerics.equals(this.meridian, directionAlongMeridian.meridian);
        }
        return false;
    }

    public int hashCode() {
        return Numerics.hashCode(Double.doubleToLongBits(this.meridian) + (long)this.baseDirection.hashCode());
    }

    @Override
    public String toString() {
        int n;
        String string = this.baseDirection.name();
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            stringBuilder.appendCodePoint(i == 0 ? Character.toUpperCase(n) : Character.toLowerCase(n));
        }
        stringBuilder.append(" along ");
        double d = Math.abs(this.meridian);
        int n3 = (int)d;
        if (d == (double)n3) {
            stringBuilder.append(n3);
        } else {
            stringBuilder.append(d);
        }
        stringBuilder.append('\u00b0');
        if (d != 0.0 && d != 180.0) {
            stringBuilder.append(this.meridian < 0.0 ? (char)'W' : 'E');
        }
        string = stringBuilder.toString();
        assert (EPSG.matcher(string).matches()) : string;
        return string;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        formatter.append(this.meridian);
        formatter.append(NonSI.DEGREE_ANGLE);
        return "Meridian";
    }
}

