/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.DefaultCompoundCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

final class Normalizer
implements Comparable<Normalizer> {
    private static final String[] EXCLUDES = new String[]{"identifiers"};
    private final CoordinateSystemAxis axis;
    private final DirectionAlongMeridian meridian;

    private Normalizer(CoordinateSystemAxis coordinateSystemAxis) {
        this.axis = coordinateSystemAxis;
        AxisDirection axisDirection = coordinateSystemAxis.getDirection();
        this.meridian = AxisDirections.isUserDefined(axisDirection) ? DirectionAlongMeridian.parse(axisDirection) : null;
    }

    @Override
    public int compareTo(Normalizer normalizer) {
        AxisDirection axisDirection = this.axis.getDirection();
        AxisDirection axisDirection2 = normalizer.axis.getDirection();
        int n = AxisDirections.angleForCompass(axisDirection2, axisDirection);
        if (n != Integer.MIN_VALUE) {
            return n;
        }
        if (this.meridian != null) {
            if (normalizer.meridian != null) {
                return this.meridian.compareTo(normalizer.meridian);
            }
            return -1;
        }
        if (normalizer.meridian != null) {
            return 1;
        }
        return axisDirection.ordinal() - axisDirection2.ordinal();
    }

    static boolean sort(CoordinateSystemAxis[] coordinateSystemAxisArray) {
        boolean bl;
        Object[] objectArray = new Normalizer[coordinateSystemAxisArray.length];
        for (bl = false; bl < coordinateSystemAxisArray.length; bl += 1) {
            objectArray[bl] = new Normalizer(coordinateSystemAxisArray[bl]);
        }
        Arrays.sort(objectArray);
        bl = false;
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = ((Normalizer)objectArray[i]).axis;
            bl |= coordinateSystemAxisArray[i] != coordinateSystemAxis;
            coordinateSystemAxisArray[i] = coordinateSystemAxis;
        }
        return bl;
    }

    static CoordinateSystemAxis normalize(CoordinateSystemAxis coordinateSystemAxis, boolean bl) {
        UnitConverter unitConverter;
        String string;
        AxisDirection axisDirection;
        AxisDirection axisDirection2 = axisDirection = coordinateSystemAxis.getDirection();
        if (!AxisDirections.isIntercardinal(axisDirection)) {
            axisDirection2 = AxisDirections.absolute(axisDirection);
        }
        boolean bl2 = axisDirection2.equals(axisDirection);
        BaseUnit baseUnit = coordinateSystemAxis.getUnit();
        Object object = bl ? (Units.isLinear(baseUnit) ? SI.METRE : (Units.isAngular(baseUnit) ? NonSI.DEGREE_ANGLE : (Units.isTemporal(baseUnit) ? NonSI.DAY : baseUnit))) : baseUnit;
        if (bl2 && object.equals((Object)baseUnit)) {
            return coordinateSystemAxis;
        }
        String string2 = string = coordinateSystemAxis.getAbbreviation();
        if (!bl2) {
            if (AxisDirections.isCompass(axisDirection)) {
                if (CharSequences.isAcronymForWords(string, axisDirection.name())) {
                    if (axisDirection2.equals(AxisDirection.EAST)) {
                        string2 = "E";
                    } else if (axisDirection2.equals(AxisDirection.NORTH)) {
                        string2 = "N";
                    }
                }
            } else if (axisDirection2.equals(AxisDirection.UP)) {
                string2 = "z";
            } else if (axisDirection2.equals(AxisDirection.FUTURE)) {
                string2 = "t";
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string2.equals(string)) {
            hashMap.putAll(IdentifiedObjects.getProperties(coordinateSystemAxis, EXCLUDES));
        } else {
            hashMap.put("name", DefaultCoordinateSystemAxis.UNNAMED);
        }
        try {
            unitConverter = baseUnit.getConverterToAny((Unit)object);
        }
        catch (ConversionException conversionException) {
            throw new IllegalStateException(Errors.format((short)43, "axis", baseUnit), conversionException);
        }
        hashMap.put("minimumValue", unitConverter.convert(coordinateSystemAxis.getMinimumValue()));
        hashMap.put("maximumValue", unitConverter.convert(coordinateSystemAxis.getMaximumValue()));
        hashMap.put("rangeMeaning", coordinateSystemAxis.getRangeMeaning());
        return new DefaultCoordinateSystemAxis((Map<String, ?>)hashMap, string2, axisDirection2, (Unit<?>)object);
    }

    static AbstractCS normalize(AbstractCS abstractCS, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n = abstractCS.getDimension();
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n];
        for (int i = 0; i < n; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = abstractCS.getAxis(i);
            if (bl) {
                bl3 |= coordinateSystemAxis != (coordinateSystemAxis = Normalizer.normalize(coordinateSystemAxis, bl2));
            }
            coordinateSystemAxisArray[i] = coordinateSystemAxis;
        }
        if (!(bl3 |= Normalizer.sort(coordinateSystemAxisArray))) {
            return abstractCS;
        }
        StringBuilder stringBuilder = (StringBuilder)CharSequences.camelCaseToSentence(abstractCS.getInterface().getSimpleName());
        return abstractCS.createSameType(Collections.singletonMap("name", DefaultCompoundCS.createName(stringBuilder, coordinateSystemAxisArray)), coordinateSystemAxisArray);
    }

    static AbstractCS shiftAxisRange(AbstractCS abstractCS) {
        boolean bl = false;
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[abstractCS.getDimension()];
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            double d;
            CoordinateSystemAxis coordinateSystemAxis = abstractCS.getAxis(i);
            RangeMeaning rangeMeaning = coordinateSystemAxis.getRangeMeaning();
            if (RangeMeaning.WRAPAROUND.equals(rangeMeaning) && (d = coordinateSystemAxis.getMinimumValue()) < 0.0) {
                double d2 = coordinateSystemAxis.getMaximumValue();
                double d3 = (d2 - d) / 2.0;
                if ((d -= (d3 *= Math.floor(d / d3 + 1.0E-10))) < (d2 -= d3)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.putAll(IdentifiedObjects.getProperties(coordinateSystemAxis, EXCLUDES));
                    hashMap.put("minimumValue", d);
                    hashMap.put("maximumValue", d2);
                    hashMap.put("rangeMeaning", rangeMeaning);
                    coordinateSystemAxis = new DefaultCoordinateSystemAxis(hashMap, coordinateSystemAxis.getAbbreviation(), coordinateSystemAxis.getDirection(), coordinateSystemAxis.getUnit());
                    bl = true;
                }
            }
            coordinateSystemAxisArray[i] = coordinateSystemAxis;
        }
        if (!bl) {
            return abstractCS;
        }
        return abstractCS.createSameType(IdentifiedObjects.getProperties(abstractCS, EXCLUDES), coordinateSystemAxisArray);
    }
}

