/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Arrays;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.ExtentSelector;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Matrix;

@XmlType(name="GeodeticDatumType", propOrder={"primeMeridian", "ellipsoid"})
@XmlRootElement(name="GeodeticDatum")
public class DefaultGeodeticDatum
extends AbstractDatum
implements GeodeticDatum {
    private static final long serialVersionUID = 8832100095648302943L;
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    private static final BursaWolfParameters[] EMPTY_ARRAY = new BursaWolfParameters[0];
    @XmlElement
    private final Ellipsoid ellipsoid;
    @XmlElement
    private final PrimeMeridian primeMeridian;
    private final BursaWolfParameters[] bursaWolf;

    private DefaultGeodeticDatum() {
        this.ellipsoid = null;
        this.primeMeridian = null;
        this.bursaWolf = null;
    }

    public DefaultGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        super(map);
        ArgumentChecks.ensureNonNull("ellipsoid", ellipsoid);
        ArgumentChecks.ensureNonNull("primeMeridian", primeMeridian);
        this.ellipsoid = ellipsoid;
        this.primeMeridian = primeMeridian;
        this.bursaWolf = CollectionsExt.nonEmpty(CollectionsExt.nonNullArraySet(BURSA_WOLF_KEY, map.get(BURSA_WOLF_KEY), EMPTY_ARRAY));
        if (this.bursaWolf != null) {
            for (int i = 0; i < this.bursaWolf.length; ++i) {
                BursaWolfParameters bursaWolfParameters = this.bursaWolf[i];
                ArgumentChecks.ensureNonNullElement(BURSA_WOLF_KEY, i, bursaWolfParameters);
                bursaWolfParameters = bursaWolfParameters.clone();
                bursaWolfParameters.verify();
                this.bursaWolf[i] = bursaWolfParameters;
            }
        }
    }

    protected DefaultGeodeticDatum(GeodeticDatum geodeticDatum) {
        super(geodeticDatum);
        this.ellipsoid = geodeticDatum.getEllipsoid();
        this.primeMeridian = geodeticDatum.getPrimeMeridian();
        this.bursaWolf = geodeticDatum instanceof DefaultGeodeticDatum ? ((DefaultGeodeticDatum)geodeticDatum).bursaWolf : null;
    }

    public static DefaultGeodeticDatum castOrCopy(GeodeticDatum geodeticDatum) {
        return geodeticDatum == null || geodeticDatum instanceof DefaultGeodeticDatum ? (DefaultGeodeticDatum)geodeticDatum : new DefaultGeodeticDatum(geodeticDatum);
    }

    public Class<? extends GeodeticDatum> getInterface() {
        return GeodeticDatum.class;
    }

    @Override
    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    @Override
    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    public BursaWolfParameters[] getBursaWolfParameters() {
        if (this.bursaWolf == null) {
            return EMPTY_ARRAY;
        }
        BursaWolfParameters[] bursaWolfParametersArray = (BursaWolfParameters[])this.bursaWolf.clone();
        for (int i = 0; i < bursaWolfParametersArray.length; ++i) {
            bursaWolfParametersArray[i] = bursaWolfParametersArray[i].clone();
        }
        return bursaWolfParametersArray;
    }

    public Matrix getPositionVectorTransformation(GeodeticDatum geodeticDatum, Extent extent) {
        ArgumentChecks.ensureNonNull("targetDatum", geodeticDatum);
        ExtentSelector<BursaWolfParameters> extentSelector = new ExtentSelector<BursaWolfParameters>(extent);
        BursaWolfParameters bursaWolfParameters = this.select(geodeticDatum, extentSelector);
        if (bursaWolfParameters != null) {
            return DefaultGeodeticDatum.createTransformation(bursaWolfParameters, extent);
        }
        if (geodeticDatum instanceof DefaultGeodeticDatum && (bursaWolfParameters = ((DefaultGeodeticDatum)geodeticDatum).select(this, extentSelector)) != null) {
            try {
                return MatrixSIS.castOrCopy(DefaultGeodeticDatum.createTransformation(bursaWolfParameters, extent)).inverse();
            }
            catch (NoninvertibleMatrixException noninvertibleMatrixException) {
                Logging.unexpectedException(DefaultGeodeticDatum.class, "getPositionVectorTransformation", noninvertibleMatrixException);
            }
        }
        return null;
    }

    private static Matrix createTransformation(BursaWolfParameters bursaWolfParameters, Extent extent) {
        return bursaWolfParameters.getPositionVectorTransformation(bursaWolfParameters.getClass() != BursaWolfParameters.class ? Extents.getDate(extent, 0.5) : null);
    }

    private BursaWolfParameters select(GeodeticDatum geodeticDatum, ExtentSelector<BursaWolfParameters> extentSelector) {
        if (this.bursaWolf == null) {
            return null;
        }
        for (BursaWolfParameters bursaWolfParameters : this.bursaWolf) {
            if (!Utilities.deepEquals(geodeticDatum, bursaWolfParameters.getTargetDatum(), ComparisonMode.IGNORE_METADATA)) continue;
            extentSelector.evaluate(bursaWolfParameters.getDomainOfValidity(), bursaWolfParameters);
        }
        return extentSelector.best();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                DefaultGeodeticDatum defaultGeodeticDatum = (DefaultGeodeticDatum)object;
                return Objects.equals(this.ellipsoid, defaultGeodeticDatum.ellipsoid) && Objects.equals(this.primeMeridian, defaultGeodeticDatum.primeMeridian) && Arrays.equals(this.bursaWolf, defaultGeodeticDatum.bursaWolf);
            }
        }
        GeodeticDatum geodeticDatum = (GeodeticDatum)object;
        return Utilities.deepEquals(this.getEllipsoid(), geodeticDatum.getEllipsoid(), comparisonMode) && Utilities.deepEquals(this.getPrimeMeridian(), geodeticDatum.getPrimeMeridian(), comparisonMode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.ellipsoid) + (long)(31 * Objects.hashCode(this.primeMeridian));
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(this.ellipsoid));
        if (formatter.getConvention().majorVersion() == 1 && this.bursaWolf != null) {
            for (BursaWolfParameters bursaWolfParameters : this.bursaWolf) {
                if (!bursaWolfParameters.isToWGS84()) continue;
                formatter.newLine();
                formatter.append(bursaWolfParameters);
                break;
            }
        }
        formatter.newLine();
        return "Datum";
    }
}

