/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.encryption.ARCFour;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryptionDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityHandler {
    private static final int DEFAULT_KEY_LENGTH = 40;
    private static final byte[] AES_SALT = new byte[]{115, 65, 108, 84};
    protected int version;
    protected int keyLength = 40;
    protected byte[] encryptionKey;
    protected PDDocument document;
    protected ARCFour rc4 = new ARCFour();
    protected boolean decryptMetadata;
    private Set<COSBase> objects = new HashSet<COSBase>();
    private Set<COSDictionary> potentialSignatures = new HashSet<COSDictionary>();
    private boolean aes;
    protected AccessPermission currentAccessPermission = null;

    public abstract void prepareDocumentForEncryption(PDDocument var1) throws CryptographyException, IOException;

    public abstract void prepareForDecryption(PDEncryptionDictionary var1, COSArray var2, DecryptionMaterial var3) throws CryptographyException, IOException;

    public abstract void decryptDocument(PDDocument var1, DecryptionMaterial var2) throws CryptographyException, IOException;

    protected void proceedDecryption() throws IOException, CryptographyException {
        COSDictionary trailer = this.document.getDocument().getTrailer();
        COSArray fields = (COSArray)trailer.getObjectFromPath("Root/AcroForm/Fields");
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                COSDictionary field = (COSDictionary)fields.getObject(i);
                if (field == null) {
                    throw new IOException("Could not decypt document, object not found.");
                }
                this.addDictionaryAndSubDictionary(this.potentialSignatures, field);
            }
        }
        List<COSObject> allObjects = this.document.getDocument().getObjects();
        Iterator<COSObject> objectIter = allObjects.iterator();
        COSDictionary encryptionDict = this.document.getEncryptionDictionary().getCOSDictionary();
        while (objectIter.hasNext()) {
            COSObject nextObj = objectIter.next();
            COSBase nextCOSBase = nextObj.getObject();
            boolean isSignatureDictionary = false;
            if (nextCOSBase instanceof COSDictionary) {
                COSDictionary dict = (COSDictionary)nextCOSBase;
                boolean bl = isSignatureDictionary = COSName.SIG.equals(dict.getDictionaryObject(COSName.FT)) || COSName.SIG.equals(dict.getDictionaryObject(COSName.TYPE));
            }
            if (isSignatureDictionary || nextCOSBase == encryptionDict) continue;
            this.decryptObject(nextObj);
        }
        this.document.setEncryptionDictionary(null);
    }

    private void addDictionaryAndSubDictionary(Set<COSDictionary> set, COSDictionary dic) {
        if (dic != null) {
            set.add(dic);
            COSArray kids = (COSArray)dic.getDictionaryObject(COSName.KIDS);
            for (int i = 0; kids != null && i < kids.size(); ++i) {
                this.addDictionaryAndSubDictionary(set, (COSDictionary)kids.getObject(i));
            }
            COSBase value = dic.getDictionaryObject(COSName.V);
            if (value instanceof COSDictionary) {
                this.addDictionaryAndSubDictionary(set, (COSDictionary)value);
            }
        }
    }

    public void encryptData(long objectNumber, long genNumber, InputStream data, OutputStream output) throws CryptographyException, IOException {
        this.encryptData(objectNumber, genNumber, data, output, false);
    }

    public void encryptData(long objectNumber, long genNumber, InputStream data, OutputStream output, boolean decrypt) throws CryptographyException, IOException {
        if (this.aes && !decrypt) {
            throw new IllegalArgumentException("AES encryption is not yet implemented.");
        }
        byte[] newKey = new byte[this.encryptionKey.length + 5];
        System.arraycopy(this.encryptionKey, 0, newKey, 0, this.encryptionKey.length);
        newKey[newKey.length - 5] = (byte)(objectNumber & 0xFFL);
        newKey[newKey.length - 4] = (byte)(objectNumber >> 8 & 0xFFL);
        newKey[newKey.length - 3] = (byte)(objectNumber >> 16 & 0xFFL);
        newKey[newKey.length - 2] = (byte)(genNumber & 0xFFL);
        newKey[newKey.length - 1] = (byte)(genNumber >> 8 & 0xFFL);
        byte[] digestedKey = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(newKey);
            if (this.aes) {
                md.update(AES_SALT);
            }
            digestedKey = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
        int length = Math.min(newKey.length, 16);
        byte[] finalKey = new byte[length];
        System.arraycopy(digestedKey, 0, finalKey, 0, length);
        if (this.aes) {
            byte[] iv = new byte[16];
            data.read(iv);
            try {
                Cipher decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                SecretKeySpec aesKey = new SecretKeySpec(finalKey, "AES");
                IvParameterSpec ips = new IvParameterSpec(iv);
                decryptCipher.init(decrypt ? 2 : 1, (Key)aesKey, ips);
                byte[] buffer = new byte[256];
                int n = 0;
                while (-1 != (n = data.read(buffer))) {
                    output.write(decryptCipher.update(buffer, 0, n));
                }
                output.write(decryptCipher.doFinal());
            }
            catch (InvalidKeyException e) {
                throw new WrappedIOException(e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new WrappedIOException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new WrappedIOException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new WrappedIOException(e);
            }
            catch (IllegalBlockSizeException e) {
                throw new WrappedIOException(e);
            }
            catch (BadPaddingException e) {
                throw new WrappedIOException(e);
            }
        } else {
            this.rc4.setKey(finalKey);
            this.rc4.write(data, output);
        }
        output.flush();
    }

    private void decryptObject(COSObject object) throws CryptographyException, IOException {
        long objNum = object.getObjectNumber().intValue();
        long genNum = object.getGenerationNumber().intValue();
        COSBase base = object.getObject();
        this.decrypt(base, objNum, genNum);
    }

    private void decrypt(COSBase obj, long objNum, long genNum) throws CryptographyException, IOException {
        if (!this.objects.contains(obj)) {
            this.objects.add(obj);
            if (obj instanceof COSString) {
                this.decryptString((COSString)obj, objNum, genNum);
            } else if (obj instanceof COSStream) {
                this.decryptStream((COSStream)obj, objNum, genNum);
            } else if (obj instanceof COSDictionary) {
                this.decryptDictionary((COSDictionary)obj, objNum, genNum);
            } else if (obj instanceof COSArray) {
                this.decryptArray((COSArray)obj, objNum, genNum);
            }
        }
    }

    public void decryptStream(COSStream stream, long objNum, long genNum) throws CryptographyException, IOException {
        COSBase type = stream.getDictionaryObject(COSName.TYPE);
        if (!this.decryptMetadata && COSName.METADATA.equals(type)) {
            return;
        }
        if (COSName.XREF.equals(type)) {
            return;
        }
        this.decryptDictionary(stream, objNum, genNum);
        InputStream encryptedStream = stream.getFilteredStream();
        this.encryptData(objNum, genNum, encryptedStream, stream.createFilteredStream(), true);
    }

    public void encryptStream(COSStream stream, long objNum, long genNum) throws CryptographyException, IOException {
        InputStream encryptedStream = stream.getFilteredStream();
        this.encryptData(objNum, genNum, encryptedStream, stream.createFilteredStream(), false);
    }

    private void decryptDictionary(COSDictionary dictionary, long objNum, long genNum) throws CryptographyException, IOException {
        for (Map.Entry<COSName, COSBase> entry : dictionary.entrySet()) {
            COSBase value = entry.getValue();
            if (!(value instanceof COSString) && !(value instanceof COSStream) && !(value instanceof COSArray) && !(value instanceof COSDictionary) || entry.getKey().equals(COSName.CONTENTS) && value instanceof COSString && this.potentialSignatures.contains(dictionary)) continue;
            this.decrypt(value, objNum, genNum);
        }
    }

    public void encryptString(COSString string, long objNum, long genNum) throws CryptographyException, IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encryptData(objNum, genNum, data, buffer, false);
        string.reset();
        string.append(buffer.toByteArray());
    }

    public void decryptString(COSString string, long objNum, long genNum) throws CryptographyException, IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encryptData(objNum, genNum, data, buffer, true);
        string.reset();
        string.append(buffer.toByteArray());
    }

    public void decryptArray(COSArray array, long objNum, long genNum) throws CryptographyException, IOException {
        for (int i = 0; i < array.size(); ++i) {
            this.decrypt(array.get(i), objNum, genNum);
        }
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(int keyLen) {
        this.keyLength = keyLen;
    }

    public AccessPermission getCurrentAccessPermission() {
        return this.currentAccessPermission;
    }

    public boolean isAES() {
        return this.aes;
    }

    public void setAES(boolean aesValue) {
        this.aes = aesValue;
    }

    public abstract boolean hasProtectionPolicy();
}

