/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.Date;
import java.util.ServiceLoader;
import org.apache.sis.internal.converter.CharSequenceConverter;
import org.apache.sis.internal.converter.ConverterRegistry;
import org.apache.sis.internal.converter.NumberConverter;
import org.apache.sis.internal.converter.ObjectToString;
import org.apache.sis.internal.converter.StringConverter;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.opengis.util.CodeList;

public final class SystemRegistry
extends ConverterRegistry {
    public static final ConverterRegistry INSTANCE = new SystemRegistry();

    private SystemRegistry() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initialize() {
        for (ObjectConverter objectConverter : ServiceLoader.load(ObjectConverter.class, this.getClass().getClassLoader())) {
            void objectConverter2;
            if (objectConverter instanceof SystemConverter) {
                ObjectConverter objectConverter3 = ((SystemConverter)objectConverter).unique();
            }
            this.register(objectConverter2);
        }
    }

    private static boolean tryInverse(Class<?> clazz) {
        return clazz == String.class || clazz == Date.class;
    }

    @Override
    protected <S, T> ObjectConverter<S, T> createConverter(Class<S> clazz, Class<T> clazz2) {
        ObjectConverter<S, T> objectConverter;
        if (SystemRegistry.tryInverse(clazz2) && !SystemRegistry.tryInverse(clazz)) {
            try {
                return this.findExact(clazz2, clazz).inverse();
            }
            catch (UnconvertibleObjectException unconvertibleObjectException) {
                // empty catch block
            }
        }
        if ((objectConverter = super.createConverter(clazz, clazz2)) != null) {
            return objectConverter;
        }
        if (clazz == CharSequence.class) {
            return new CharSequenceConverter<T>(clazz2, this.find(String.class, clazz2));
        }
        if (clazz == String.class) {
            if (CodeList.class.isAssignableFrom(clazz2)) {
                return new StringConverter.CodeList<CodeList>(clazz2.asSubclass(CodeList.class));
            }
            if (clazz2.isEnum()) {
                return new StringConverter.Enum<Enum>(clazz2.asSubclass(Enum.class));
            }
        }
        if (clazz == Number.class || SystemRegistry.isSupportedNumber(clazz)) {
            if (SystemRegistry.isSupportedNumber(clazz2)) {
                return new NumberConverter<Number, Number>(clazz.asSubclass(Number.class), clazz2.asSubclass(Number.class));
            }
            if (clazz2 == Comparable.class) {
                return new NumberConverter.Comparable<Number>(clazz.asSubclass(Number.class));
            }
        }
        if (clazz2 == String.class) {
            return new ObjectToString<S>(clazz, null);
        }
        return null;
    }

    private static boolean isSupportedNumber(Class<?> clazz) {
        byte by = Numbers.getEnumConstant(clazz);
        return by >= 3 && by <= 10;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.utility"){

            @Override
            protected void classpathChanged() {
                INSTANCE.clear();
            }
        });
    }
}

