/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public final class NonMarshalledAuthority<T>
extends SimpleCitation
implements IdentifierSpace<T>,
Serializable {
    private static final long serialVersionUID = 6299502270649111201L;
    private static volatile boolean warningLogged;
    public static final int ID = 0;
    public static final int UUID = 1;
    public static final int HREF = 2;
    public static final int XLINK = 3;
    public static final int ISSN = 4;
    public static final int ISBN = 5;
    final transient int ordinal;

    public NonMarshalledAuthority(String string, int n) {
        super(string);
        this.ordinal = n;
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public String toString() {
        return "IdentifierSpace[" + this.title + ']';
    }

    public static <T extends Identifier> T getMarshallable(Collection<? extends T> collection) {
        if (collection != null) {
            for (Identifier identifier : collection) {
                if (identifier == null || identifier.getAuthority() instanceof NonMarshalledAuthority) continue;
                return (T)identifier;
            }
        }
        return null;
    }

    public static <T extends Identifier> void setMarshallable(Collection<T> collection, T t) {
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            if (identifier != null && identifier.getAuthority() instanceof NonMarshalledAuthority) continue;
            iterator.remove();
        }
        if (t != null) {
            collection.add(t);
        }
    }

    public static Collection<Identifier> excludeOnMarshalling(Collection<Identifier> collection) {
        int n;
        if (collection != null && Context.isFlagSet(Context.current(), 1) && (n = collection.size()) != 0) {
            Identifier[] identifierArray = collection.toArray(new Identifier[n]);
            int n2 = n;
            while (--n2 >= 0) {
                Identifier identifier = identifierArray[n2];
                if (identifier != null && !(identifier.getAuthority() instanceof NonMarshalledAuthority)) continue;
                System.arraycopy(identifierArray, n2 + 1, identifierArray, n2, --n - n2);
            }
            collection = n != 0 ? UnmodifiableArrayList.wrap(identifierArray, 0, n) : null;
        }
        return collection;
    }

    public static <T extends Identifier> Collection<T> filteredCopy(Collection<T> collection) {
        ArrayList<Identifier> arrayList = null;
        if (collection != null) {
            int n = collection.size();
            for (Identifier identifier : collection) {
                if (identifier != null && identifier.getAuthority() instanceof NonMarshalledAuthority) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Identifier>(n);
                    }
                    arrayList.add(identifier);
                }
                --n;
            }
        }
        return arrayList;
    }

    public static <T extends Identifier> void replace(Collection<T> collection, Collection<T> collection2) {
        if (collection2 != null && collection != null) {
            for (Identifier identifier : collection2) {
                Citation citation = identifier.getAuthority();
                Iterator<T> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Identifier identifier2 = (Identifier)iterator.next();
                    if (identifier2 != null && identifier2.getAuthority() != citation) continue;
                    iterator.remove();
                }
            }
            collection.addAll(collection2);
        }
    }

    private static IdentifierSpace<?> getCitation(String string) {
        try {
            Field field = Class.forName("org.apache.sis.metadata.iso.citation.DefaultCitation").getDeclaredField(string);
            field.setAccessible(true);
            return (IdentifierSpace)field.get(null);
        }
        catch (Exception exception) {
            if (!warningLogged) {
                warningLogged = true;
                LogRecord logRecord = Errors.getResources((Locale)null).getLogRecord(Level.WARNING, (short)61, "sis-metadata");
                logRecord.setThrown(exception);
                Logging.log(NonMarshalledAuthority.class, "readResolve", logRecord);
            }
            return null;
        }
    }

    private Object readResolve() {
        int n = 0;
        while (true) {
            IdentifierSpace<Object> identifierSpace;
            switch (n) {
                case 0: {
                    identifierSpace = IdentifierSpace.ID;
                    break;
                }
                case 1: {
                    identifierSpace = IdentifierSpace.UUID;
                    break;
                }
                case 2: {
                    identifierSpace = IdentifierSpace.HREF;
                    break;
                }
                case 3: {
                    identifierSpace = IdentifierSpace.XLINK;
                    break;
                }
                case 5: {
                    identifierSpace = NonMarshalledAuthority.getCitation("ISBN");
                    break;
                }
                case 4: {
                    identifierSpace = NonMarshalledAuthority.getCitation("ISSN");
                    break;
                }
                default: {
                    return this;
                }
            }
            if (identifierSpace instanceof NonMarshalledAuthority && ((NonMarshalledAuthority)identifierSpace).title.equals(this.title)) {
                return identifierSpace;
            }
            ++n;
        }
    }
}

