/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gmd.Country;
import org.apache.sis.internal.jaxb.gmd.LanguageCode;
import org.apache.sis.internal.jaxb.gmd.PT_FreeText;
import org.apache.sis.internal.jaxb.gmx.Anchor;
import org.apache.sis.internal.jaxb.gmx.FileName;
import org.apache.sis.internal.jaxb.gmx.MimeFileType;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Messages;

@XmlType(name="CharacterString_PropertyType")
@XmlSeeAlso(value={PT_FreeText.class, LanguageCode.class, Country.class})
public class GO_CharacterString {
    public static final byte MIME_TYPE = 1;
    public static final byte FILENAME = 2;
    private static final byte ANCHOR = 3;
    private CharSequence text;
    public byte type;

    private static String nameOf(byte by) {
        switch (by) {
            case 0: {
                return "CharacterString";
            }
            case 1: {
                return "MimeFileType";
            }
            case 2: {
                return "FileName";
            }
            case 3: {
                return "Anchor";
            }
        }
        throw new AssertionError(by);
    }

    public GO_CharacterString() {
    }

    protected GO_CharacterString(CharSequence charSequence) {
        this.text = charSequence;
    }

    private void setText(CharSequence charSequence, byte by) {
        if (this.text != null && !charSequence.equals(this.text)) {
            byte by2 = this.type;
            boolean bl = false;
            if (by2 > by) {
                by2 = by;
                by = this.type;
                bl = true;
            }
            Context.warningOccured(Context.current(), Context.LOGGER, this.getClass(), "setText", Messages.class, (short)2, GO_CharacterString.nameOf(by2), GO_CharacterString.nameOf(by));
            if (bl) {
                return;
            }
        }
        this.text = charSequence;
        this.type = by;
    }

    @XmlElement(name="CharacterString")
    public final String getCharacterString() {
        CharSequence charSequence;
        if (this.type == 0 && (charSequence = this.text) != null && !(charSequence instanceof Anchor)) {
            return charSequence.toString();
        }
        return null;
    }

    public final void setCharacterString(String string) {
        if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
            this.setText(string, (byte)0);
        }
    }

    @XmlElement(name="FileName", namespace="http://www.isotc211.org/2005/gmx")
    final FileName getFileName() {
        CharSequence charSequence;
        if (this.type == 2 && (charSequence = this.text) != null && !(charSequence instanceof Anchor)) {
            return new FileName(charSequence.toString());
        }
        return null;
    }

    final void setFileName(FileName fileName) {
        String string;
        if (fileName != null && (string = CharSequences.trimWhitespaces(fileName.toString())) != null && !string.isEmpty()) {
            this.setText(string, (byte)2);
        }
    }

    @XmlElement(name="MimeFileType", namespace="http://www.isotc211.org/2005/gmx")
    final MimeFileType getMimeFileType() {
        CharSequence charSequence;
        if (this.type == 1 && (charSequence = this.text) != null && !(charSequence instanceof Anchor)) {
            return new MimeFileType(charSequence.toString());
        }
        return null;
    }

    final void setMimeFileType(MimeFileType mimeFileType) {
        String string;
        if (mimeFileType != null && (string = CharSequences.trimWhitespaces(mimeFileType.toString())) != null && !string.isEmpty()) {
            this.setText(string, (byte)1);
        }
    }

    @XmlElement(name="Anchor", namespace="http://www.isotc211.org/2005/gmx")
    public final Anchor getAnchor() {
        CharSequence charSequence = this.text;
        return charSequence instanceof Anchor ? (Anchor)charSequence : null;
    }

    public final void setAnchor(Anchor anchor) {
        this.setText(anchor, (byte)3);
    }

    public CharSequence toCharSequence() {
        CharSequence charSequence = CharSequences.trimWhitespaces(this.text);
        if (charSequence != null && (charSequence.length() != 0 || charSequence instanceof Anchor)) {
            return charSequence;
        }
        return null;
    }

    public final String toString() {
        CharSequence charSequence = this.text;
        return charSequence != null ? charSequence.toString() : null;
    }
}

