/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gmd;

import java.util.Locale;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.GO_CharacterString;
import org.apache.sis.internal.jaxb.gmd.LocalisedCharacterString;
import org.apache.sis.internal.jaxb.gmd.TextGroup;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.iso.DefaultInternationalString;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.opengis.util.InternationalString;

@XmlType(name="PT_FreeText_PropertyType")
public final class PT_FreeText
extends GO_CharacterString {
    @XmlElementWrapper(name="PT_FreeText")
    @XmlElement(required=true)
    private TextGroup[] textGroup;

    private PT_FreeText() {
    }

    private PT_FreeText(String string, TextGroup[] textGroupArray) {
        super(string);
        this.textGroup = textGroupArray;
    }

    public static PT_FreeText create(Context context, InternationalString internationalString) {
        if (internationalString instanceof DefaultInternationalString) {
            DefaultInternationalString defaultInternationalString = (DefaultInternationalString)internationalString;
            Set<Locale> set = defaultInternationalString.getLocales();
            TextGroup[] textGroupArray = new TextGroup[set.size()];
            int n = 0;
            for (Locale locale : set) {
                if (locale == null || locale.equals(Locale.ROOT)) continue;
                textGroupArray[n++] = new TextGroup(locale, internationalString.toString(locale));
            }
            if (n != 0) {
                return new PT_FreeText(defaultInternationalString.toString(context != null ? context.getLocale() : null), ArraysExt.resize(textGroupArray, n));
            }
        }
        return null;
    }

    private boolean contains(String string) {
        TextGroup[] textGroupArray = this.textGroup;
        if (textGroupArray != null) {
            for (TextGroup textGroup : textGroupArray) {
                LocalisedCharacterString[] localisedCharacterStringArray;
                if (textGroup == null || (localisedCharacterStringArray = textGroup.localized) == null) continue;
                for (LocalisedCharacterString localisedCharacterString : localisedCharacterStringArray) {
                    if (!string.equals(localisedCharacterString.text)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public CharSequence toCharSequence() {
        String string = this.toString();
        if (string != null && this.contains(string)) {
            string = null;
        }
        DefaultInternationalString defaultInternationalString = null;
        TextGroup[] textGroupArray = this.textGroup;
        if (textGroupArray != null) {
            for (TextGroup textGroup : textGroupArray) {
                LocalisedCharacterString[] localisedCharacterStringArray;
                if (textGroup == null || (localisedCharacterStringArray = textGroup.localized) == null) continue;
                for (LocalisedCharacterString localisedCharacterString : localisedCharacterStringArray) {
                    if (localisedCharacterString == null) continue;
                    if (defaultInternationalString == null) {
                        defaultInternationalString = new DefaultInternationalString(string);
                    }
                    defaultInternationalString.add(localisedCharacterString.locale, localisedCharacterString.text);
                }
            }
        }
        if (defaultInternationalString == null && string != null) {
            return new SimpleInternationalString(string);
        }
        return defaultInternationalString;
    }
}

