/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.simple;

import java.io.Serializable;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public class SimpleIdentifier
implements ReferenceIdentifier,
Serializable {
    private static final long serialVersionUID = -3544709943777129514L;
    protected final Citation authority;
    protected final String code;

    public SimpleIdentifier(Citation citation, String string) {
        this.authority = citation;
        this.code = string;
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    @Override
    public String getCodeSpace() {
        return Citations.getIdentifier(this.authority);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getVersion() {
        InternationalString internationalString;
        if (this.authority != null && (internationalString = this.authority.getEdition()) != null) {
            return internationalString.toString();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            SimpleIdentifier simpleIdentifier = (SimpleIdentifier)object;
            return Objects.equals(this.code, simpleIdentifier.code) && Objects.equals(this.authority, simpleIdentifier.authority);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.authority, this.code) ^ 0x395E8BD6;
    }

    public String toString() {
        String string = Classes.getShortClassName(this);
        StringBuilder stringBuilder = new StringBuilder(string.length() + CharSequences.length(this.code) + 10);
        stringBuilder.append(string).append('[');
        String string2 = this.getCodeSpace();
        boolean bl = false;
        if (string2 != null) {
            stringBuilder.append('\u201c').append(string2);
            bl = true;
        }
        if (this.code != null) {
            stringBuilder.append(bl ? (char)':' : '\u201c').append(this.code);
            bl = true;
        }
        if (bl) {
            stringBuilder.append('\u201d');
        }
        this.appendToString(stringBuilder);
        return stringBuilder.append(']').toString();
    }

    protected void appendToString(StringBuilder stringBuilder) {
    }

    public String toWKT() {
        StringBuilder stringBuilder = new StringBuilder(40).append("ID[");
        SimpleIdentifier.append(stringBuilder, Citations.getIdentifier(this.authority));
        SimpleIdentifier.append(stringBuilder.append(", "), this.code);
        return stringBuilder.append(']').toString();
    }

    private static void append(StringBuilder stringBuilder, String string) {
        if (string == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append('\"').append(string).append('\"');
        }
    }
}

