/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.sis.internal.util.LocalizedException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public final class LocalizedParseException
extends ParseException
implements LocalizedException {
    private static final long serialVersionUID = -1467571540435486742L;
    private final Locale locale;
    private final short key;
    private final Object[] arguments;

    public LocalizedParseException(Locale locale, short s, Object[] objectArray, int n) {
        super(Errors.format(s, objectArray), n);
        this.locale = locale;
        this.arguments = objectArray;
        this.key = s;
    }

    public LocalizedParseException(Locale locale, short s, CharSequence charSequence, int n) {
        this(locale, s, new Object[]{CharSequences.token(charSequence, n)}, n);
    }

    public LocalizedParseException(Locale locale, Class<?> clazz, CharSequence charSequence, ParsePosition parsePosition) {
        this(locale, clazz, charSequence, parsePosition != null ? parsePosition.getIndex() : 0, parsePosition != null ? parsePosition.getErrorIndex() : 0);
    }

    private LocalizedParseException(Locale locale, Class<?> clazz, CharSequence charSequence, int n, int n2) {
        this(locale, LocalizedParseException.arguments(clazz, charSequence, n, Math.max(n, n2)), n2);
    }

    private LocalizedParseException(Locale locale, Object[] objectArray, int n) {
        this(locale, LocalizedParseException.key(objectArray), objectArray, n);
    }

    private static Object[] arguments(Class<?> clazz, CharSequence charSequence, int n, int n2) {
        if (n2 >= charSequence.length()) {
            return new Object[]{charSequence};
        }
        CharSequence charSequence2 = CharSequences.token(charSequence = charSequence.subSequence(n, charSequence.length()), n2);
        if (charSequence2.length() == 0) {
            return new Object[]{clazz, charSequence};
        }
        return new Object[]{clazz, charSequence, charSequence2};
    }

    private static short key(Object[] objectArray) {
        short s;
        switch (objectArray.length) {
            case 1: {
                s = 110;
                break;
            }
            case 2: {
                s = 124;
                break;
            }
            case 3: {
                s = 125;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return s;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String getLocalizedMessage() {
        return Errors.getResources(this.locale).getString(this.key, this.arguments);
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        return Errors.getResources(locale).getString(this.key, this.arguments);
    }
}

