/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.Appender;
import org.apache.sis.io.IO;
import org.apache.sis.io.LineAppender;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.resources.Errors;

public class TableAppender
extends Appender
implements Flushable {
    public static final byte ALIGN_LEFT = -1;
    public static final byte ALIGN_CENTER = 0;
    public static final byte ALIGN_RIGHT = 1;
    private static final char[][] BOX = new char[][]{{'\u250c', '\u252c', '\u2510', '\u251c', '\u253c', '\u2524', '\u2514', '\u2534', '\u2518', '\u2500', '\u2502'}, {'\u2553', '\u2565', '\u2556', '\u255f', '\u256b', '\u2562', '\u2559', '\u2568', '\u255c', '\u2500', '\u2551'}, {'\u2552', '\u2564', '\u2555', '\u255e', '\u256a', '\u2561', '\u2558', '\u2567', '\u255b', '\u2550', '\u2502'}, {'\u2554', '\u2566', '\u2557', '\u2560', '\u256c', '\u2563', '\u255a', '\u2569', '\u255d', '\u2550', '\u2551'}};
    private static final char SPACE = ' ';
    private final StringBuilder buffer = new StringBuilder(64);
    private final List<Cell> cells = new ArrayList<Cell>();
    private byte alignment = (byte)-1;
    private int currentColumn;
    private int currentRow;
    private int[] maximalColumnWidths = ArraysExt.EMPTY_INT;
    private String lineSeparator;
    private final String columnSeparator;
    private final String leftBorder;
    private final String rightBorder;
    private boolean multiLinesCells;
    private boolean skipLF;
    private boolean ownOut;

    public TableAppender() {
        this(new StringBuilder(256));
        this.ownOut = true;
    }

    public TableAppender(String string) {
        this(new StringBuilder(256), string);
        this.ownOut = true;
    }

    public TableAppender(Appendable appendable) {
        super(appendable);
        this.leftBorder = "\u2551 ";
        this.rightBorder = " \u2551";
        this.columnSeparator = " \u2502 ";
    }

    public TableAppender(Appendable appendable, String string) {
        super(appendable);
        int n = string.length();
        this.leftBorder = string.substring(CharSequences.skipLeadingWhitespaces(string, 0, n));
        this.rightBorder = string.substring(0, CharSequences.skipTrailingWhitespaces(string, 0, n));
        this.columnSeparator = string;
    }

    private void writeBorder(int n, int n2, char c) throws IOException {
        Object object;
        int n3 = 0;
        char[][] cArrayArray = new char[BOX.length][];
        for (char[] cArray : BOX) {
            if (cArray[9] != c) continue;
            cArrayArray[n3++] = cArray;
        }
        switch (n) {
            case -1: {
                object = this.leftBorder;
                break;
            }
            case 1: {
                object = this.rightBorder;
                break;
            }
            case 0: {
                object = this.columnSeparator;
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
        assert (n2 >= -1 && n2 <= 1) : n2;
        int n4 = n + 1 + (n2 + 1) * 3;
        int n5 = ((String)object).length();
        int n6 = 0;
        while (n6 < n5) {
            int n7 = ((String)object).codePointAt(n6);
            n6 += Character.charCount(n7);
            if (Character.isWhitespace(n7)) {
                n7 = c;
            } else {
                for (int i = 0; i < n3; ++i) {
                    if (cArrayArray[i][10] != n7) continue;
                    n7 = cArrayArray[i][n4];
                    break;
                }
            }
            this.appendCodePoint(n7);
        }
    }

    public boolean isMultiLinesCells() {
        return this.multiLinesCells;
    }

    public void setMultiLinesCells(boolean bl) {
        this.multiLinesCells = bl;
    }

    public byte getCellAlignment() {
        return this.alignment;
    }

    public void setCellAlignment(byte by) {
        if (by < -1 || by > 1) {
            throw new IllegalArgumentException(Errors.format((short)31, "alignment", by));
        }
        this.alignment = by;
    }

    public int getRowCount() {
        int n = this.currentRow;
        if (this.currentColumn != 0) {
            ++n;
        }
        return n;
    }

    public int getColumnCount() {
        return this.maximalColumnWidths.length;
    }

    @Override
    public TableAppender append(char c) {
        int n = this.toCodePoint(c);
        if (!this.multiLinesCells) {
            if (n == 9) {
                this.nextColumn();
                this.skipLF = false;
                return this;
            }
            if (Characters.isLineOrParagraphSeparator(n)) {
                if (n == 10) {
                    if (!this.skipLF) {
                        this.nextLine();
                    }
                    this.skipLF = false;
                } else {
                    this.nextLine();
                    this.skipLF = true;
                }
                return this;
            }
        }
        this.buffer.appendCodePoint(n);
        this.skipLF = false;
        return this;
    }

    @Override
    public TableAppender append(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    @Override
    public TableAppender append(CharSequence charSequence, int n, int n2) {
        ArgumentChecks.ensureValidIndexRange(charSequence.length(), n, n2);
        if (this.lineSeparator == null) {
            this.lineSeparator = this.lineSeparator(charSequence, n, n2);
        }
        try {
            n = this.appendSurrogate(charSequence, n, n2);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        if (n != n2) {
            if (this.skipLF && charSequence.charAt(n) == '\n') {
                ++n;
            }
            if (!this.multiLinesCells) {
                int n3 = 0;
                int n4 = n;
                while (n4 != n2) {
                    if ((n3 = this.toCodePoint(charSequence.charAt(n4++))) < 0 || n3 != 9 && !Characters.isLineOrParagraphSeparator(n3)) continue;
                    this.buffer.append(charSequence, n, n4 - Character.charCount(n3));
                    switch (n3) {
                        case 13: {
                            if (n4 >= n2 || charSequence.charAt(n4) == '\n') {
                                // empty if block
                            }
                        }
                        default: {
                            this.nextLine();
                            break;
                        }
                        case 9: {
                            this.nextColumn();
                        }
                    }
                    n = ++n4;
                }
                this.skipLF = n3 == 13;
            } else {
                assert (!this.isHighSurrogate());
                boolean bl = this.skipLF = this.toCodePoint(charSequence.charAt(n2 - 1)) == 13;
            }
            if (this.isHighSurrogate()) {
                --n2;
            }
            this.buffer.append(charSequence, n, n2);
        }
        return this;
    }

    public void appendHorizontalSeparator() {
        if (this.currentColumn != 0 || this.buffer.length() != 0) {
            this.nextLine();
        }
        this.nextLine('\u2500');
    }

    public void nextColumn() {
        this.nextColumn(' ');
    }

    public void nextColumn(char c) {
        String string = this.buffer.toString();
        this.cells.add(new Cell(string, this.alignment, c));
        if (this.currentColumn >= this.maximalColumnWidths.length) {
            this.maximalColumnWidths = Arrays.copyOf(this.maximalColumnWidths, this.currentColumn + 1);
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4;
            int n5 = n4 = CharSequences.indexOfLineStart(string, 1, n2);
            while (--n5 >= n2) {
                int n6;
                if (Character.isISOControl(string.charAt(n5)) || (n6 = X364.lengthOfPlain(string, n2, n5 + 1)) <= n) continue;
                n = n6;
            }
            n2 = n4;
        }
        if (n > this.maximalColumnWidths[this.currentColumn]) {
            this.maximalColumnWidths[this.currentColumn] = n;
        }
        ++this.currentColumn;
        this.buffer.setLength(0);
    }

    public void nextLine() {
        this.nextLine(' ');
    }

    public void nextLine(char c) {
        if (this.buffer.length() != 0) {
            this.nextColumn(c);
        }
        assert (this.buffer.length() == 0);
        this.cells.add(c != ' ' ? new Cell(null, this.alignment, c) : null);
        this.currentColumn = 0;
        ++this.currentRow;
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer.length() != 0) {
            this.nextLine();
            assert (this.buffer.length() == 0);
        }
        if (!this.ownOut) {
            this.writeTable();
        }
        this.cells.clear();
        this.currentRow = 0;
        this.currentColumn = 0;
        if (!(this.out instanceof TableAppender)) {
            IO.flush(this.out);
        }
    }

    @Override
    public String toString() {
        if (this.ownOut) {
            ((StringBuilder)this.out).setLength(0);
            try {
                this.writeTable();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
        return super.toString();
    }

    private void writeTable() throws IOException {
        String string = this.columnSeparator;
        Object[] objectArray = new Cell[this.maximalColumnWidths.length];
        int n = this.cells.size();
        for (int i = 0; i < n; ++i) {
            Cell cell;
            Cell cell2 = null;
            int n2 = 0;
            while ((cell = this.cells.get(i)) != null) {
                if (cell.text == null) {
                    cell2 = new Cell("", cell.alignment, cell.fill);
                    break;
                }
                objectArray[n2++] = cell;
                if (++i < n) continue;
            }
            Arrays.fill(objectArray, n2, objectArray.length, cell2);
            while (!TableAppender.isEmpty(objectArray)) {
                for (int j = 0; j < objectArray.length; ++j) {
                    int n3;
                    int n4;
                    boolean bl = j == 0;
                    boolean bl2 = j + 1 == objectArray.length;
                    Object object = objectArray[j];
                    int n5 = this.maximalColumnWidths[j];
                    int n6 = n4 = bl2 && this.rightBorder.isEmpty() ? 0 : n5;
                    if (object == null) {
                        if (bl) {
                            this.out.append(this.leftBorder);
                        }
                        TableAppender.repeat(this.out, ' ', n4);
                        this.out.append(bl2 ? this.rightBorder : string);
                        continue;
                    }
                    String string2 = ((Cell)object).text;
                    int n7 = string2.length();
                    Cell cell3 = null;
                    int n8 = 0;
                    while (n8 < n7) {
                        n3 = string2.codePointAt(n8);
                        int n9 = n8 + Character.charCount(n3);
                        if (Characters.isLineOrParagraphSeparator(n3)) {
                            if (n3 != 13 || n9 >= n7 || string2.charAt(n9) == '\n') {
                                // empty if block
                            }
                            for (int k = ++n9; k < n7; k += Character.charCount(n3)) {
                                n3 = string2.codePointAt(k);
                                if (Character.isWhitespace(n3)) continue;
                                cell3 = ((Cell)object).substring(n9);
                                break;
                            }
                            string2 = string2.substring(0, n8);
                            break;
                        }
                        n8 = n9;
                    }
                    objectArray[j] = cell3;
                    n7 = X364.lengthOfPlain(string2, 0, string2.length());
                    if (n2 == 0) {
                        assert (n7 == 0);
                        n8 = i == 0 ? -1 : (i >= n - 1 ? 1 : 0);
                        if (bl) {
                            this.writeBorder(-1, n8, ((Cell)object).fill);
                        }
                        TableAppender.repeat(this.out, ((Cell)object).fill, Character.isWhitespace(((Cell)object).fill) ? n4 : n5);
                        this.writeBorder(bl2 ? 1 : 0, n8, ((Cell)object).fill);
                        continue;
                    }
                    if (bl) {
                        this.out.append(this.leftBorder);
                    }
                    Appendable appendable = string2.indexOf(9) >= 0 ? new LineAppender(this.out, Integer.MAX_VALUE, true) : this.out;
                    switch (((Cell)object).alignment) {
                        default: {
                            throw new AssertionError(((Cell)object).alignment);
                        }
                        case -1: {
                            appendable.append(string2);
                            TableAppender.repeat(appendable, ((Cell)object).fill, n4 - n7);
                            break;
                        }
                        case 1: {
                            TableAppender.repeat(appendable, ((Cell)object).fill, n5 - n7);
                            appendable.append(string2);
                            break;
                        }
                        case 0: {
                            n3 = (n5 - n7) / 2;
                            TableAppender.repeat(appendable, ((Cell)object).fill, n3);
                            appendable.append(string2);
                            TableAppender.repeat(appendable, ((Cell)object).fill, n4 - n3 - n7);
                            break;
                        }
                    }
                    this.out.append(bl2 ? this.rightBorder : string);
                }
                if (this.lineSeparator == null) {
                    this.lineSeparator = JDK7.lineSeparator();
                }
                this.out.append(this.lineSeparator);
            }
        }
    }

    private static boolean isEmpty(Object[] objectArray) {
        int n = objectArray.length;
        while (--n >= 0) {
            if (objectArray[n] == null) continue;
            return false;
        }
        return true;
    }

    private static void repeat(Appendable appendable, char c, int n) throws IOException {
        while (--n >= 0) {
            appendable.append(c);
        }
    }

    private static final class Cell {
        final String text;
        byte alignment;
        final char fill;

        Cell(String string, byte by, char c) {
            this.text = string;
            this.alignment = by;
            this.fill = c;
        }

        Cell substring(int n) {
            return new Cell(this.text.substring(n), this.alignment, this.fill);
        }

        public String toString() {
            return this.text;
        }
    }
}

