/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.util.Arrays;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class MathFunctions
extends Static {
    public static final double SQRT_2 = 1.4142135623730951;
    public static final double LOG10_2 = 0.3010299956639812;
    private static final int MIN_NAN_ORDINAL = -2097152;
    static final int MAX_NAN_ORDINAL = 0x1FFFFF;
    public static final int HIGHEST_SUPPORTED_PRIME_NUMBER = 65521;
    static final int PRIMES_LENGTH_15_BITS = 3512;
    static final int PRIMES_LENGTH_16_BITS = 6542;
    private static volatile short[] primes = new short[]{2, 3};

    private MathFunctions() {
    }

    public static double truncate(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MIN_VALUE) == 0L ? Math.floor(d) : Math.ceil(d);
    }

    public static double magnitude(double ... dArray) {
        double d;
        double d2;
        double d3;
        int n = dArray.length;
        do {
            if (n != 0) continue;
            return 0.0;
        } while ((d3 = dArray[--n]) == 0.0);
        do {
            if (n != 0) continue;
            return Math.abs(d3);
        } while ((d2 = dArray[--n]) == 0.0);
        do {
            if (n != 0) continue;
            return Math.hypot(d3, d2);
        } while ((d = dArray[--n]) == 0.0);
        DoubleDouble doubleDouble = new DoubleDouble();
        DoubleDouble doubleDouble2 = new DoubleDouble();
        doubleDouble.setToProduct(d3, d3);
        doubleDouble2.setToProduct(d2, d2);
        doubleDouble.add(doubleDouble2);
        doubleDouble2.setToProduct(d, d);
        doubleDouble.add(doubleDouble2);
        while (n != 0) {
            d3 = dArray[--n];
            doubleDouble2.setToProduct(d3, d3);
            doubleDouble.add(doubleDouble2);
        }
        doubleDouble.sqrt();
        return doubleDouble.value;
    }

    public static int getExponent(double d) {
        long l = Double.doubleToRawLongBits(d);
        int n = (int)(l >>> 52 & 0x7FFL);
        if (n == 0) {
            n -= Long.numberOfLeadingZeros(l & 0xFFFFFFFFFFFFFL) - 12;
        }
        return n - 1023;
    }

    public static double pow10(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return DecimalFunctions.pow10(n);
        }
        return Math.pow(10.0, d);
    }

    public static double pow10(int n) {
        return DecimalFunctions.pow10(n);
    }

    public static double atanh(double d) {
        return 0.5 * Math.log1p(2.0 * d / (1.0 - d));
    }

    public static boolean isPositive(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MIN_VALUE) == 0L && !Double.isNaN(d);
    }

    public static boolean isPositiveZero(double d) {
        return Double.doubleToRawLongBits(d) == 0L;
    }

    public static boolean isNegative(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MIN_VALUE) != 0L && !Double.isNaN(d);
    }

    public static boolean isNegativeZero(double d) {
        return Double.doubleToRawLongBits(d) == Long.MIN_VALUE;
    }

    public static boolean isSameSign(double d, double d2) {
        return !Double.isNaN(d) && !Double.isNaN(d2) && ((Double.doubleToRawLongBits(d) ^ Double.doubleToRawLongBits(d2)) & Long.MIN_VALUE) == 0L;
    }

    public static double xorSign(double d, double d2) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) ^ Double.doubleToRawLongBits(d2) & Long.MIN_VALUE);
    }

    public static boolean epsilonEqual(float f, float f2, float f3) {
        return Math.abs(f - f2) <= f3 || Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static boolean epsilonEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3 || Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static float toNanFloat(int n) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("ordinal", -2097152, 0x1FFFFF, n);
        float f = Float.intBitsToFloat(2143289344 + n);
        assert (Float.isNaN(f) && MathFunctions.toNanOrdinal(f) == n) : n;
        return f;
    }

    public static int toNanOrdinal(float f) throws IllegalArgumentException {
        Object object;
        short s;
        int n = Float.floatToRawIntBits(f) - 2143289344;
        if (n >= -2097152 && n <= 0x1FFFFF) {
            return n;
        }
        if (Float.isNaN(f)) {
            s = 33;
            object = Integer.toHexString(n);
        } else {
            s = 31;
            object = Float.valueOf(f);
        }
        throw new IllegalArgumentException(Errors.format(s, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int primeNumberAt(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(6542, n);
        short[] sArray = primes;
        if (n < sArray.length) return sArray[n] & 0xFFFF;
        Class<MathFunctions> clazz = MathFunctions.class;
        synchronized (MathFunctions.class) {
            sArray = primes;
            if (n < sArray.length) return sArray[n] & 0xFFFF;
            int n2 = sArray.length;
            int n3 = sArray[n2 - 1] & 0xFFFF;
            sArray = Arrays.copyOf(sArray, Math.min((n | 0xF) + 1, 6542));
            block3: while (true) {
                int n4;
                int n5 = (int)Math.sqrt(n3 += 2);
                int n6 = 0;
                do {
                    if (n3 % (n4 = sArray[++n6] & 0xFFFF) == 0) continue block3;
                } while (n4 <= n5);
                sArray[n2] = (short)n3;
                if (++n2 >= sArray.length) break;
            }
            primes = sArray;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sArray[n] & 0xFFFF;
        }
    }

    public static int nextPrimeNumber(int n) throws IllegalArgumentException {
        int n2;
        ArgumentChecks.ensureBetween("number", 2, 65521, n);
        short[] sArray = primes;
        int n3 = 0;
        int n4 = Math.min(3512, sArray.length);
        if (n > Short.MAX_VALUE) {
            n3 = n4;
            n4 = sArray.length;
        }
        if ((n2 = Arrays.binarySearch(sArray, n3, n4, (short)n)) < 0 && (n2 ^= 0xFFFFFFFF) >= sArray.length) {
            int n5;
            while ((n5 = MathFunctions.primeNumberAt(n2++)) < n) {
            }
            return n5;
        }
        return sArray[n2] & 0xFFFF;
    }

    public static int[] divisors(int n) {
        int n2;
        int n3;
        if (n == 0) {
            return ArraysExt.EMPTY_INT;
        }
        n = Math.abs(n);
        int[] nArray = new int[16];
        nArray[0] = 1;
        int n4 = 1;
        int n5 = (int)Math.sqrt(n);
        int n6 = 0;
        while ((n3 = MathFunctions.primeNumberAt(n6)) <= n5) {
            if (n % n3 == 0) {
                if (n4 == nArray.length) {
                    nArray = Arrays.copyOf(nArray, n4 * 2);
                }
                nArray[n4++] = n3;
            }
            ++n6;
        }
        n3 = n4;
        if (n4 * 2 > nArray.length) {
            nArray = Arrays.copyOf(nArray, n4 * 2);
        }
        if ((n6 = nArray[--n3]) != (n2 = n / n6)) {
            nArray[n4++] = n2;
        }
        while (--n3 >= 0) {
            nArray[n4++] = n / nArray[n3];
        }
        for (int i = 1; i < n4; ++i) {
            n6 = nArray[i];
            for (int j = i; j < n4; ++j) {
                int n7;
                n2 = n6 * nArray[j];
                if (n % n2 != 0 || (n7 = Arrays.binarySearch(nArray, j, n4, n2)) >= 0) continue;
                n7 ^= 0xFFFFFFFF;
                if (n4 == nArray.length) {
                    nArray = Arrays.copyOf(nArray, n4 * 2);
                }
                System.arraycopy(nArray, n7, nArray, n7 + 1, n4 - n7);
                nArray[n7] = n2;
                ++n4;
            }
        }
        nArray = ArraysExt.resize(nArray, n4);
        assert (ArraysExt.isSorted(nArray, true));
        return nArray;
    }

    public static int[] commonDivisors(int ... nArray) {
        int n;
        if (nArray.length == 0) {
            return ArraysExt.EMPTY_INT;
        }
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.abs(nArray[i]);
            if (n > n2) continue;
            n2 = n;
        }
        int[] nArray2 = MathFunctions.divisors(n2);
        n = nArray2.length;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = Math.abs(nArray[i]);
            if (n3 == n2) continue;
            int n4 = n;
            while (--n4 > 0) {
                if (n3 % nArray2[n4] == 0) continue;
                System.arraycopy(nArray2, n4 + 1, nArray2, n4, --n - n4);
            }
        }
        return ArraysExt.resize(nArray2, n);
    }
}

