/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.Standards;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.DefaultMetadataScope;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultAddress;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.citation.DefaultContact;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.iso.constraint.DefaultLegalConstraints;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.apache.sis.metadata.iso.content.DefaultRangeElementDescription;
import org.apache.sis.metadata.iso.distribution.DefaultDistribution;
import org.apache.sis.metadata.iso.distribution.DefaultDistributor;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.metadata.iso.identification.DefaultKeywords;
import org.apache.sis.metadata.iso.lineage.DefaultLineage;
import org.apache.sis.metadata.iso.quality.DefaultDataQuality;
import org.apache.sis.metadata.iso.spatial.DefaultDimension;
import org.apache.sis.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

final class MetadataReader {
    private static final String[] SEARCH_PATH = new String[]{"NCISOMetadata", "CFMetadata", null, "THREDDSMetadata"};
    private static final String[] SERVICES = new String[]{"wms_service", "wcs_service"};
    private static final String KEYWORD_SEPARATOR = ",";
    private static final VerticalCRS VERTICAL_CRS = null;
    private final Decoder decoder;
    private final String[] searchPath;
    private transient DefaultNameFactory nameFactory;
    private transient ResponsibleParty pointOfContact;

    MetadataReader(Decoder decoder) throws IOException {
        this.decoder = decoder;
        decoder.setSearchPath(SEARCH_PATH);
        this.searchPath = decoder.getSearchPath();
    }

    private void warning(Exception exception) {
        this.decoder.listeners.warning(null, exception);
    }

    private Errors errors() {
        return Errors.getResources(this.decoder.listeners.getLocale());
    }

    private String stringValue(String string) throws IOException {
        String string2 = this.decoder.stringValue(string);
        if (string2 != null && (string2 = string2.trim()).isEmpty()) {
            string2 = null;
        }
        return string2;
    }

    private static InternationalString toInternationalString(String string) {
        return string != null ? new SimpleInternationalString(string) : null;
    }

    private <T extends Enum<T>> T forEnumName(Class<T> clazz, String string) {
        T t = Types.forEnumName(clazz, string);
        if (t == null && string != null) {
            this.decoder.listeners.warning(this.errors().getString((short)114, clazz, string), null);
        }
        return t;
    }

    private <T extends CodeList<T>> T forCodeName(Class<T> clazz, String string) {
        T t = Types.forCodeName(clazz, string, false);
        if (t == null && string != null) {
            this.decoder.listeners.warning(this.errors().getString((short)114, clazz, string), null);
        }
        return t;
    }

    private static <T> T first(Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    private static <T> void addIfAbsent(Collection<T> collection, T t) {
        if (!collection.contains(t)) {
            collection.add(t);
        }
    }

    private static <T> Set<T> addIfNonNull(Set<T> set, T t) {
        if (t != null) {
            if (set == null) {
                set = new LinkedHashSet<T>(4);
            }
            set.add(t);
        }
        return set;
    }

    private static boolean canShare(CharSequence charSequence, String string) {
        return string == null || charSequence != null && charSequence.toString().equals(string);
    }

    private static boolean canShare(Collection<String> collection, String string) {
        return string == null || collection.contains(string);
    }

    private static boolean canShare(OnlineResource onlineResource, String string) {
        return string == null || onlineResource != null && MetadataReader.canShare(onlineResource.getLinkage().toString(), string);
    }

    private static boolean canShare(Address address, String string) {
        return string == null || address != null && MetadataReader.canShare(address.getElectronicMailAddresses(), string);
    }

    private OnlineResource createOnlineResource(String string) {
        if (string != null) {
            try {
                DefaultOnlineResource defaultOnlineResource = new DefaultOnlineResource(new URI(string));
                defaultOnlineResource.setProtocol("http");
                defaultOnlineResource.setApplicationProfile("web browser");
                defaultOnlineResource.setFunction(OnLineFunction.INFORMATION);
                return defaultOnlineResource;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.warning(uRISyntaxException);
            }
        }
        return null;
    }

    private static Address createAddress(String string) {
        if (string != null) {
            DefaultAddress defaultAddress = new DefaultAddress();
            defaultAddress.setElectronicMailAddresses(Collections.singleton(string));
            return defaultAddress;
        }
        return null;
    }

    private static Contact createContact(Address address, OnlineResource onlineResource) {
        if (address != null || onlineResource != null) {
            DefaultContact defaultContact = new DefaultContact();
            if (address != null) {
                defaultContact.setAddresses(Collections.singleton(address));
            }
            if (onlineResource != null) {
                defaultContact.setOnlineResources(Collections.singleton(onlineResource));
            }
            return defaultContact;
        }
        return null;
    }

    private ResponsibleParty createResponsibleParty(AttributeNames.Responsible responsible, boolean bl) throws IOException {
        String string = this.stringValue(responsible.NAME);
        String string2 = this.stringValue(responsible.INSTITUTION);
        String string3 = this.stringValue(responsible.EMAIL);
        String string4 = this.stringValue(responsible.URL);
        if (string == null && string2 == null && string3 == null && string4 == null) {
            return null;
        }
        Role role = this.forCodeName(Role.class, this.stringValue(responsible.ROLE));
        if (role == null) {
            role = bl ? Role.POINT_OF_CONTACT : responsible.DEFAULT_ROLE;
        }
        ResponsibleParty responsibleParty = this.pointOfContact;
        Contact contact = null;
        Address address = null;
        OnlineResource onlineResource = null;
        if (responsibleParty != null) {
            contact = responsibleParty.getContactInfo();
            if (contact != null) {
                address = contact.getAddress();
                onlineResource = contact.getOnlineResource();
            }
            if (!MetadataReader.canShare(onlineResource, string4)) {
                onlineResource = null;
                contact = null;
                responsibleParty = null;
            }
            if (!MetadataReader.canShare(address, string3)) {
                address = null;
                contact = null;
                responsibleParty = null;
            }
            if (!(responsibleParty == null || MetadataReader.canShare((CharSequence)responsibleParty.getOrganisationName(), string2) && MetadataReader.canShare(responsibleParty.getIndividualName(), string))) {
                responsibleParty = null;
            }
        }
        if (responsibleParty == null) {
            if (contact == null) {
                if (address == null) {
                    address = MetadataReader.createAddress(string3);
                }
                if (onlineResource == null) {
                    onlineResource = this.createOnlineResource(string4);
                }
                contact = MetadataReader.createContact(address, onlineResource);
            }
            if (string != null || string2 != null || contact != null) {
                AbstractParty abstractParty = null;
                if (string != null) {
                    abstractParty = new DefaultIndividual(string, null, null);
                }
                if (string2 != null) {
                    abstractParty = new DefaultOrganisation(string2, null, (DefaultIndividual)abstractParty, null);
                }
                if (abstractParty == null) {
                    abstractParty = new AbstractParty();
                }
                if (contact != null) {
                    abstractParty.setContactInfo(Collections.singleton(contact));
                }
                responsibleParty = new DefaultResponsibleParty(role);
                ((DefaultResponsibleParty)responsibleParty).setParties(Collections.singleton(abstractParty));
            }
        }
        return responsibleParty;
    }

    private Citation createCitation(Identifier identifier) throws IOException {
        String string = this.stringValue("title");
        if (string == null && (string = this.stringValue("full_name")) == null && (string = this.stringValue("name")) == null) {
            string = this.decoder.getTitle();
        }
        Date date = this.decoder.dateValue("date_created");
        Date date2 = this.decoder.dateValue("date_modified");
        Date date3 = this.decoder.dateValue("date_issued");
        String string2 = this.stringValue("references");
        DefaultCitation defaultCitation = new DefaultCitation(string);
        if (identifier != null) {
            defaultCitation.setIdentifiers(Collections.singleton(identifier));
        }
        if (date != null) {
            defaultCitation.setDates(Collections.singleton(new DefaultCitationDate(date, DateType.CREATION)));
        }
        if (date2 != null) {
            defaultCitation.getDates().add(new DefaultCitationDate(date2, DateType.REVISION));
        }
        if (date3 != null) {
            defaultCitation.getDates().add(new DefaultCitationDate(date3, DateType.PUBLICATION));
        }
        if (this.pointOfContact != null) {
            DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(this.pointOfContact);
            defaultResponsibleParty.setRole(Role.ORIGINATOR);
            defaultCitation.setCitedResponsibleParties(Collections.singleton(defaultResponsibleParty));
        }
        for (String string3 : this.searchPath) {
            this.decoder.setSearchPath(string3);
            ResponsibleParty responsibleParty = this.createResponsibleParty(AttributeNames.CONTRIBUTOR, false);
            if (responsibleParty == null || responsibleParty == this.pointOfContact) continue;
            MetadataReader.addIfAbsent(defaultCitation.getCitedResponsibleParties(), responsibleParty);
        }
        this.decoder.setSearchPath(this.searchPath);
        if (string2 != null) {
            defaultCitation.setOtherCitationDetails(new SimpleInternationalString(string2));
        }
        return defaultCitation.isEmpty() ? null : defaultCitation;
    }

    private DataIdentification createIdentificationInfo(Identifier identifier, Set<InternationalString> set) throws IOException {
        AbstractIdentification abstractIdentification = null;
        Set<InternationalString> set2 = null;
        DefaultLegalConstraints defaultLegalConstraints = null;
        boolean bl = false;
        for (String string : this.searchPath) {
            Extent extent;
            this.decoder.setSearchPath(string);
            Keywords keywords = this.createKeywords(KeywordType.THEME, true);
            Keywords keywords2 = this.createKeywords(KeywordType.THEME, false);
            String string2 = this.stringValue("topic_category");
            String string3 = this.stringValue("cdm_data_type");
            String string4 = this.stringValue("acknowledgment");
            String string5 = this.stringValue("license");
            String string6 = this.stringValue("acces_constraint");
            Extent extent2 = extent = bl ? null : this.createExtent();
            if (keywords != null || keywords2 != null || string2 != null || string3 != null || string4 != null || string5 != null || string6 != null || extent != null) {
                if (abstractIdentification == null) {
                    abstractIdentification = new DefaultDataIdentification();
                }
                if (string2 != null) {
                    MetadataReader.addIfAbsent(abstractIdentification.getTopicCategories(), this.forCodeName(TopicCategory.class, string2));
                }
                if (string3 != null) {
                    MetadataReader.addIfAbsent(abstractIdentification.getSpatialRepresentationTypes(), this.forCodeName(SpatialRepresentationType.class, string3));
                }
                if (keywords != null) {
                    MetadataReader.addIfAbsent(abstractIdentification.getDescriptiveKeywords(), keywords);
                }
                if (keywords2 != null) {
                    MetadataReader.addIfAbsent(abstractIdentification.getDescriptiveKeywords(), keywords2);
                }
                if (string4 != null) {
                    MetadataReader.addIfAbsent(abstractIdentification.getCredits(), string4);
                }
                if (string5 != null) {
                    defaultLegalConstraints = new DefaultLegalConstraints(string5);
                    MetadataReader.addIfAbsent(abstractIdentification.getResourceConstraints(), defaultLegalConstraints);
                }
                if (string6 != null) {
                    for (String string7 : string6.split(KEYWORD_SEPARATOR)) {
                        if ((string7 = string7.trim()).isEmpty()) continue;
                        if (defaultLegalConstraints == null) {
                            defaultLegalConstraints = new DefaultLegalConstraints();
                            abstractIdentification.getResourceConstraints().add(defaultLegalConstraints);
                        }
                        MetadataReader.addIfAbsent(defaultLegalConstraints.getAccessConstraints(), this.forCodeName(Restriction.class, string7));
                    }
                }
                if (extent != null) {
                    abstractIdentification.setExtents(Collections.singleton(extent));
                    bl = true;
                }
            }
            set2 = MetadataReader.addIfNonNull(set2, MetadataReader.toInternationalString(this.stringValue("project")));
        }
        this.decoder.setSearchPath(this.searchPath);
        Citation citation = this.createCitation(identifier);
        String string = this.stringValue("summary");
        String string8 = this.stringValue("purpose");
        if (abstractIdentification == null) {
            if (citation == null && string == null && string8 == null && set2 == null && set == null && this.pointOfContact == null) {
                return null;
            }
            abstractIdentification = new DefaultDataIdentification();
        }
        abstractIdentification.setCitation(citation);
        abstractIdentification.setAbstract(MetadataReader.toInternationalString(string));
        abstractIdentification.setPurpose(MetadataReader.toInternationalString(string8));
        if (this.pointOfContact != null) {
            abstractIdentification.setPointOfContacts(Collections.singleton(this.pointOfContact));
        }
        this.addKeywords((DefaultDataIdentification)abstractIdentification, set2, KeywordType.valueOf((String)"project"));
        this.addKeywords((DefaultDataIdentification)abstractIdentification, set, KeywordType.valueOf((String)"dataCentre"));
        ((DefaultDataIdentification)abstractIdentification).setSupplementalInformation(MetadataReader.toInternationalString(this.stringValue("comment")));
        return abstractIdentification;
    }

    private void addKeywords(DefaultDataIdentification defaultDataIdentification, Set<InternationalString> set, KeywordType keywordType) {
        if (set != null) {
            DefaultKeywords defaultKeywords = new DefaultKeywords();
            defaultKeywords.setKeywords(set);
            defaultKeywords.setType(keywordType);
            defaultDataIdentification.getDescriptiveKeywords().add(defaultKeywords);
        }
    }

    private Keywords createKeywords(KeywordType keywordType, boolean bl) throws IOException {
        String string = this.stringValue(bl ? "standard_name" : "keywords");
        DefaultKeywords defaultKeywords = null;
        if (string != null) {
            LinkedHashSet<SimpleInternationalString> linkedHashSet = new LinkedHashSet<SimpleInternationalString>();
            for (String string2 : string.split(KEYWORD_SEPARATOR)) {
                if ((string2 = string2.trim()).isEmpty()) continue;
                linkedHashSet.add(new SimpleInternationalString(string2));
            }
            if (!linkedHashSet.isEmpty()) {
                defaultKeywords = new DefaultKeywords();
                defaultKeywords.setKeywords(linkedHashSet);
                defaultKeywords.setType(keywordType);
                String string3 = this.stringValue(bl ? "standard_name_vocabulary" : "keywords_vocabulary");
                if (string3 != null) {
                    defaultKeywords.setThesaurusName(new DefaultCitation(string3));
                }
            }
        }
        return defaultKeywords;
    }

    private GridSpatialRepresentation createSpatialRepresentationInfo(GridGeometry gridGeometry) throws IOException {
        DefaultGridSpatialRepresentation defaultGridSpatialRepresentation = new DefaultGridSpatialRepresentation();
        defaultGridSpatialRepresentation.setNumberOfDimensions(gridGeometry.getTargetDimensions());
        Axis[] axisArray = gridGeometry.getAxes();
        int n = axisArray.length;
        while (--n >= 0) {
            Axis axis = axisArray[n];
            if (axis.sourceDimensions.length == 0) continue;
            DefaultDimension defaultDimension = new DefaultDimension();
            defaultDimension.setDimensionSize(axis.sourceSizes[0]);
            AttributeNames.Dimension dimension = axis.attributeNames;
            if (dimension != null) {
                defaultDimension.setDimensionName(dimension.DEFAULT_NAME_TYPE);
                Number number = this.decoder.numericValue(dimension.RESOLUTION);
                if (number != null) {
                    defaultDimension.setResolution(number instanceof Double ? ((Double)number).doubleValue() : number.doubleValue());
                }
            }
            defaultGridSpatialRepresentation.getAxisDimensionProperties().add(defaultDimension);
        }
        defaultGridSpatialRepresentation.setCellGeometry(CellGeometry.AREA);
        return defaultGridSpatialRepresentation;
    }

    private Extent createExtent() throws IOException {
        Object object;
        Object object2;
        Object object3;
        DefaultExtent defaultExtent = null;
        Number number = this.decoder.numericValue(AttributeNames.LONGITUDE.MINIMUM);
        Number number2 = this.decoder.numericValue(AttributeNames.LONGITUDE.MAXIMUM);
        Number number3 = this.decoder.numericValue(AttributeNames.LATITUDE.MINIMUM);
        Number number4 = this.decoder.numericValue(AttributeNames.LATITUDE.MAXIMUM);
        Number number5 = this.decoder.numericValue(AttributeNames.VERTICAL.MINIMUM);
        Number number6 = this.decoder.numericValue(AttributeNames.VERTICAL.MAXIMUM);
        if (number != null || number2 != null || number3 != null || number4 != null) {
            object3 = this.getConverterTo(this.decoder.unitValue(AttributeNames.LONGITUDE.UNITS), NonSI.DEGREE_ANGLE);
            object2 = this.getConverterTo(this.decoder.unitValue(AttributeNames.LATITUDE.UNITS), NonSI.DEGREE_ANGLE);
            defaultExtent = new DefaultExtent(null, new DefaultGeographicBoundingBox(MetadataReader.valueOf(number, object3), MetadataReader.valueOf(number2, object3), MetadataReader.valueOf(number3, object2), MetadataReader.valueOf(number4, object2)), null, null);
        }
        if (number5 != null || number6 != null) {
            object3 = this.getConverterTo(this.decoder.unitValue(AttributeNames.VERTICAL.UNITS), (Unit<?>)SI.METRE);
            double d = MetadataReader.valueOf(number5, object3);
            double d2 = MetadataReader.valueOf(number6, object3);
            if ("down".equals(this.stringValue(AttributeNames.VERTICAL.POSITIVE))) {
                double d3 = d;
                d = -d2;
                d2 = -d3;
            }
            if (defaultExtent == null) {
                defaultExtent = new DefaultExtent();
            }
            defaultExtent.setVerticalElements(Collections.singleton(new DefaultVerticalExtent(d, d2, VERTICAL_CRS)));
        }
        object3 = this.decoder.dateValue(AttributeNames.TIME.MINIMUM);
        object2 = this.decoder.dateValue(AttributeNames.TIME.MAXIMUM);
        if (object3 == null && object2 == null) {
            String string;
            object = this.decoder.numericValue(AttributeNames.TIME.MINIMUM);
            Number number7 = this.decoder.numericValue(AttributeNames.TIME.MAXIMUM);
            if ((object != null || number7 != null) && (string = this.stringValue(AttributeNames.TIME.UNITS)) != null) {
                Date[] dateArray = this.decoder.numberToDate(string, new Number[]{object, number7});
                object3 = dateArray[0];
                object2 = dateArray[1];
            }
        }
        if (object3 != null || object2 != null) {
            try {
                object = new DefaultTemporalExtent();
                ((DefaultTemporalExtent)object).setBounds((Date)object3, (Date)object2);
                if (defaultExtent == null) {
                    defaultExtent = new DefaultExtent();
                }
                defaultExtent.setTemporalElements(Collections.singleton(object));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.warning(unsupportedOperationException);
            }
        }
        if ((object = this.stringValue("geographic_identifier")) != null) {
            if (defaultExtent == null) {
                defaultExtent = new DefaultExtent();
            }
            defaultExtent.setGeographicElements(Collections.singleton(new DefaultGeographicDescription(null, (String)object)));
        }
        return defaultExtent;
    }

    private UnitConverter getConverterTo(Unit<?> unit, Unit<?> unit2) {
        if (unit != null) {
            try {
                return unit.getConverterToAny(unit2);
            }
            catch (ConversionException conversionException) {
                this.warning((Exception)((Object)conversionException));
            }
        }
        return null;
    }

    private static double valueOf(Number number, UnitConverter unitConverter) {
        double d = Double.NaN;
        if (number != null) {
            d = number.doubleValue();
            if (unitConverter != null) {
                d = unitConverter.convert(d);
            }
        }
        return d;
    }

    private Collection<DefaultCoverageDescription> createContentInfo() throws IOException {
        HashMap<List<String>, DefaultCoverageDescription> hashMap = new HashMap<List<String>, DefaultCoverageDescription>(4);
        String string = this.stringValue("processing_level");
        for (Variable variable : this.decoder.getVariables()) {
            if (!variable.isCoverage(2)) continue;
            DefaultAttributeGroup defaultAttributeGroup = null;
            List<String> list = Arrays.asList(variable.getGridDimensionNames());
            DefaultCoverageDescription defaultCoverageDescription = (DefaultCoverageDescription)hashMap.get(list);
            if (defaultCoverageDescription == null) {
                if (string != null) {
                    defaultCoverageDescription = new DefaultImageDescription();
                    ((DefaultImageDescription)defaultCoverageDescription).setProcessingLevelCode(new DefaultIdentifier(string));
                } else {
                    defaultCoverageDescription = new DefaultCoverageDescription();
                }
                hashMap.put(list, defaultCoverageDescription);
            } else {
                defaultAttributeGroup = MetadataReader.first(defaultCoverageDescription.getAttributeGroups());
            }
            if (defaultAttributeGroup == null) {
                defaultAttributeGroup = new DefaultAttributeGroup();
                defaultCoverageDescription.setAttributeGroups(Collections.singleton(defaultAttributeGroup));
            }
            defaultAttributeGroup.getAttributes().add((RangeDimension)this.createSampleDimension(variable));
            Object[] objectArray = variable.getAttributeValues("flag_names", false);
            Object[] objectArray2 = variable.getAttributeValues("flag_meanings", false);
            Object[] objectArray3 = variable.getAttributeValues("flag_masks", true);
            Object[] objectArray4 = variable.getAttributeValues("flag_values", true);
            int n = Math.max(objectArray3.length, Math.max(objectArray4.length, Math.max(objectArray.length, objectArray2.length)));
            for (int i = 0; i < n; ++i) {
                RangeElementDescription rangeElementDescription = this.createRangeElementDescription(variable, i < objectArray.length ? (String)objectArray[i] : null, i < objectArray2.length ? (String)objectArray2[i] : null, i < objectArray3.length ? (Number)((Number)objectArray3[i]) : (Number)null, i < objectArray4.length ? (Number)((Number)objectArray4[i]) : (Number)null);
                if (rangeElementDescription == null) continue;
                defaultCoverageDescription.getRangeElementDescriptions().add(rangeElementDescription);
            }
        }
        return hashMap.values();
    }

    private Band createSampleDimension(Variable variable) throws IOException {
        String string;
        String string2;
        DefaultBand defaultBand = new DefaultBand();
        String string3 = variable.getName();
        if (string3 != null && !(string3 = string3.trim()).isEmpty()) {
            if (this.nameFactory == null) {
                this.nameFactory = DefaultFactories.NAMES;
            }
            defaultBand.setSequenceIdentifier(this.nameFactory.createMemberName(null, string3, this.nameFactory.createTypeName(null, variable.getDataTypeName())));
        }
        if ((string2 = variable.getDescription()) != null && !(string2 = string2.trim()).isEmpty() && !string2.equals(string3)) {
            defaultBand.setDescription(new SimpleInternationalString(string2));
        }
        if ((string = variable.getUnitsString()) != null) {
            try {
                defaultBand.setUnits(Units.valueOf(string));
            }
            catch (RuntimeException runtimeException) {
                this.decoder.listeners.warning(this.errors().getString((short)168, string3, string), runtimeException);
            }
        }
        return defaultBand;
    }

    private RangeElementDescription createRangeElementDescription(Variable variable, String string, String string2, Number number, Number number2) throws IOException {
        if (string != null && string2 != null) {
            DefaultRangeElementDescription defaultRangeElementDescription = new DefaultRangeElementDescription();
            defaultRangeElementDescription.setName(new SimpleInternationalString(string));
            defaultRangeElementDescription.setDefinition(new SimpleInternationalString(string2));
            return defaultRangeElementDescription;
        }
        return null;
    }

    private Identifier getFileIdentifier() throws IOException {
        String string = this.stringValue("id");
        if (string == null && (string = this.decoder.getId()) == null) {
            return null;
        }
        String string2 = this.stringValue("naming_authority");
        return new DefaultIdentifier(string2 != null ? new DefaultCitation(string2) : null, string);
    }

    /*
     * WARNING - void declaration
     */
    public Metadata read() throws IOException {
        void var4_7;
        String string;
        DefaultMetadata defaultMetadata = new DefaultMetadata();
        defaultMetadata.setMetadataStandards(Collections.singleton(Standards.ISO_19115_2));
        Identifier identifier = this.getFileIdentifier();
        defaultMetadata.setMetadataIdentifier(identifier);
        Date date = this.decoder.dateValue("metadata_creation");
        if (date != null) {
            defaultMetadata.setDateInfo(Collections.singleton(new DefaultCitationDate(date, DateType.CREATION)));
        }
        defaultMetadata.setMetadataScopes(Collections.singleton(new DefaultMetadataScope(ScopeCode.DATASET, null)));
        for (String string2 : SERVICES) {
            string = this.stringValue(string2);
            if (string == null) continue;
            MetadataReader.addIfAbsent(defaultMetadata.getMetadataScopes(), new DefaultMetadataScope(ScopeCode.SERVICE, string));
        }
        for (String string2 : this.searchPath) {
            this.decoder.setSearchPath(string2);
            string = this.createResponsibleParty(AttributeNames.CREATOR, true);
            if (string == null || string == this.pointOfContact) continue;
            MetadataReader.addIfAbsent(defaultMetadata.getContacts(), string);
            if (this.pointOfContact != null) continue;
            this.pointOfContact = string;
        }
        Object var4_6 = null;
        DefaultDistribution defaultDistribution = null;
        for (String string3 : this.searchPath) {
            Object object;
            this.decoder.setSearchPath(string3);
            ResponsibleParty responsibleParty = this.createResponsibleParty(AttributeNames.PUBLISHER, false);
            if (responsibleParty != null) {
                if (defaultDistribution == null) {
                    defaultDistribution = new DefaultDistribution();
                    defaultMetadata.setDistributionInfo(defaultDistribution);
                }
                object = new DefaultDistributor(responsibleParty);
                MetadataReader.addIfAbsent(defaultDistribution.getDistributors(), object);
                Set<InternationalString> set2 = MetadataReader.addIfNonNull(var4_7, responsibleParty.getOrganisationName());
                set2 = MetadataReader.addIfNonNull(set2, MetadataReader.toInternationalString(responsibleParty.getIndividualName()));
            }
            if ((object = this.stringValue("history")) == null) continue;
            DefaultDataQuality defaultDataQuality = new DefaultDataQuality();
            DefaultLineage defaultLineage = new DefaultLineage();
            defaultLineage.setStatement(new SimpleInternationalString((String)object));
            defaultDataQuality.setLineage(defaultLineage);
            MetadataReader.addIfAbsent(defaultMetadata.getDataQualityInfo(), defaultDataQuality);
        }
        DataIdentification dataIdentification = this.createIdentificationInfo(identifier, (Set<InternationalString>)var4_7);
        if (dataIdentification != null) {
            defaultMetadata.setIdentificationInfo(Collections.singleton(dataIdentification));
        }
        defaultMetadata.setContentInfo(this.createContentInfo());
        for (GridGeometry gridGeometry : this.decoder.getGridGeometries()) {
            if (gridGeometry.getSourceDimensions() < 2 || gridGeometry.getTargetDimensions() < 2) continue;
            defaultMetadata.getSpatialRepresentationInfo().add((SpatialRepresentation)this.createSpatialRepresentationInfo(gridGeometry));
        }
        return defaultMetadata;
    }
}

