/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public abstract class ReferencingServices
extends SystemListener {
    public static final double NAUTICAL_MILE = 1852.0;
    public static final double AUTHALIC_RADIUS = 6371007.0;
    private static volatile ReferencingServices instance;

    protected ReferencingServices() {
        super("org.apache.sis.metadata");
        SystemListener.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void classpathChanged() {
        Class<ReferencingServices> clazz = ReferencingServices.class;
        synchronized (ReferencingServices.class) {
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReferencingServices getInstance() throws UnsupportedOperationException {
        ReferencingServices referencingServices = instance;
        if (referencingServices != null) return referencingServices;
        Class<ReferencingServices> clazz = ReferencingServices.class;
        synchronized (ReferencingServices.class) {
            referencingServices = instance;
            if (referencingServices != null) return referencingServices;
            try {
                instance = referencingServices = (ReferencingServices)Class.forName("org.apache.sis.internal.referencing.ServicesForMetadata").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnsupportedOperationException(Errors.format((short)61, "sis-referencing"), classNotFoundException);
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
            return referencingServices;
        }
    }

    public abstract Matrix getMatrix(MathTransform var1);

    public abstract ParameterDescriptor<?> toImplementation(ParameterDescriptor<?> var1);

    public abstract FormattableObject toFormattableObject(IdentifiedObject var1);

    public abstract void setBounds(Envelope var1, DefaultGeographicBoundingBox var2) throws TransformException;

    public abstract void setBounds(Envelope var1, DefaultVerticalExtent var2) throws TransformException;

    public abstract void setBounds(Envelope var1, DefaultTemporalExtent var2) throws TransformException;

    public abstract void setBounds(Envelope var1, DefaultSpatialTemporalExtent var2) throws TransformException;

    public abstract void addElements(Envelope var1, DefaultExtent var2) throws TransformException;
}

