/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.io.Serializable;
import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.IdentifierMapWithSpecialCases;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;

@XmlTransient
public class ISOMetadata
extends ModifiableMetadata
implements IdentifiedObject,
Serializable {
    private static final long serialVersionUID = -4997239501383133209L;
    public static final Logger LOGGER = Logging.getLogger(ISOMetadata.class);
    protected Collection<Identifier> identifiers;

    protected ISOMetadata() {
    }

    protected ISOMetadata(Object object) {
        if (object instanceof IdentifiedObject) {
            if (object instanceof ISOMetadata && Containers.isNullOrEmpty(((ISOMetadata)object).identifiers) && object.getClass().getName().startsWith("org.apache.sis.")) {
                return;
            }
            this.identifiers = this.copyCollection(((IdentifiedObject)object).getIdentifiers(), Identifier.class);
        }
    }

    @Override
    public MetadataStandard getStandard() {
        return MetadataStandard.ISO_19115;
    }

    public Collection<Identifier> getIdentifiers() {
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        return this.identifiers;
    }

    @Override
    public IdentifierMap getIdentifierMap() {
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        if (this.identifiers == null) {
            return IdentifierMapWithSpecialCases.EMPTY;
        }
        return new IdentifierMapWithSpecialCases(this.identifiers);
    }

    @XmlID
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getID() {
        return Containers.isNullOrEmpty(this.identifiers) ? null : this.getIdentifierMap().getSpecialized(IdentifierSpace.ID);
    }

    private void setID(String string) {
        if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
            this.getIdentifierMap().putSpecialized(IdentifierSpace.ID, string);
        }
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getUUID() {
        return Containers.isNullOrEmpty(this.identifiers) ? null : (String)this.getIdentifierMap().get(IdentifierSpace.UUID);
    }

    private void setUUID(String string) {
        this.getIdentifierMap().put(IdentifierSpace.UUID, string);
    }
}

