/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.IdentifierMapWithSpecialCases;
import org.apache.sis.internal.jaxb.gco.GO_Integer64;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.identification.RepresentativeFraction;

@XmlType(name="MD_RepresentativeFraction_Type")
@XmlRootElement(name="MD_RepresentativeFraction")
public class DefaultRepresentativeFraction
extends Number
implements RepresentativeFraction,
IdentifiedObject {
    private static final long serialVersionUID = -6043871487256529207L;
    private long denominator;
    private Collection<Identifier> identifiers;

    public DefaultRepresentativeFraction() {
    }

    public DefaultRepresentativeFraction(long l) {
        ArgumentChecks.ensurePositive("denominator", l);
        this.denominator = l;
    }

    public DefaultRepresentativeFraction(RepresentativeFraction representativeFraction) {
        if (representativeFraction != null) {
            this.denominator = representativeFraction.getDenominator();
        }
    }

    public static DefaultRepresentativeFraction castOrCopy(RepresentativeFraction representativeFraction) {
        return representativeFraction == null || representativeFraction instanceof DefaultRepresentativeFraction ? (DefaultRepresentativeFraction)representativeFraction : new DefaultRepresentativeFraction(representativeFraction);
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlJavaTypeAdapter(value=GO_Integer64.class, type=long.class)
    @XmlElement(name="denominator", required=true)
    public long getDenominator() {
        return this.denominator;
    }

    public void setDenominator(long l) {
        if (l < 0L) {
            MetadataUtilities.warnNonPositiveArgument(DefaultRepresentativeFraction.class, "denominator", false, l);
        }
        this.denominator = l;
    }

    public void setScale(double d) {
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException(d <= 0.0 ? Errors.format((short)132, "scale", d) : Errors.format((short)133, "scale", 0, 1, d));
        }
        this.setDenominator(Math.round(1.0 / d));
    }

    @Override
    public double doubleValue() {
        return this.denominator != 0L ? 1.0 / (double)this.denominator : Double.NaN;
    }

    @Override
    public float floatValue() {
        return this.denominator != 0L ? 1.0f / (float)this.denominator : Float.NaN;
    }

    @Override
    public long longValue() {
        return this.denominator == 1L ? 1L : 0L;
    }

    @Override
    public int intValue() {
        return this.denominator == 1L ? 1 : 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof RepresentativeFraction) {
            return ((RepresentativeFraction)object).getDenominator() == this.denominator;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)this.denominator;
    }

    public String toString() {
        return this.denominator != 0L ? "1:" + this.denominator : "NaN";
    }

    public Collection<Identifier> getIdentifiers() {
        if (this.identifiers == null) {
            this.identifiers = new CheckedArrayList<Identifier>(Identifier.class);
        }
        return this.identifiers;
    }

    @Override
    public IdentifierMap getIdentifierMap() {
        return new IdentifierMapWithSpecialCases(this.getIdentifiers());
    }

    @XmlID
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getID() {
        return Containers.isNullOrEmpty(this.identifiers) ? null : this.getIdentifierMap().getSpecialized(IdentifierSpace.ID);
    }

    private void setID(String string) {
        if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
            this.getIdentifierMap().putSpecialized(IdentifierSpace.ID, string);
        }
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getUUID() {
        return Containers.isNullOrEmpty(this.identifiers) ? null : (String)this.getIdentifierMap().get(IdentifierSpace.UUID);
    }

    private void setUUID(String string) {
        this.getIdentifierMap().put(IdentifierSpace.UUID, string);
    }
}

