/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.NikonType1MakernoteDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NikonType1MakernoteDescriptor
extends TagDescriptor<NikonType1MakernoteDirectory> {
    public NikonType1MakernoteDescriptor(@NotNull NikonType1MakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 3: {
                return this.getQualityDescription();
            }
            case 4: {
                return this.getColorModeDescription();
            }
            case 5: {
                return this.getImageAdjustmentDescription();
            }
            case 6: {
                return this.getCcdSensitivityDescription();
            }
            case 7: {
                return this.getWhiteBalanceDescription();
            }
            case 8: {
                return this.getFocusDescription();
            }
            case 10: {
                return this.getDigitalZoomDescription();
            }
            case 11: {
                return this.getConverterDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getConverterDescription() {
        return this.getIndexedDescription(11, "None", "Fisheye converter");
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Rational value = ((NikonType1MakernoteDirectory)this._directory).getRational(10);
        return value == null ? null : (value.getNumerator() == 0L ? "No digital zoom" : value.toSimpleString(true) + "x digital zoom");
    }

    @Nullable
    public String getFocusDescription() {
        Rational value = ((NikonType1MakernoteDirectory)this._directory).getRational(8);
        return value == null ? null : (value.getNumerator() == 1L && value.getDenominator() == 0L ? "Infinite" : value.toSimpleString(true));
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        return this.getIndexedDescription(7, "Auto", "Preset", "Daylight", "Incandescence", "Florescence", "Cloudy", "SpeedLight");
    }

    @Nullable
    public String getCcdSensitivityDescription() {
        return this.getIndexedDescription(6, "ISO80", null, "ISO160", null, "ISO320", "ISO100");
    }

    @Nullable
    public String getImageAdjustmentDescription() {
        return this.getIndexedDescription(5, "Normal", "Bright +", "Bright -", "Contrast +", "Contrast -");
    }

    @Nullable
    public String getColorModeDescription() {
        return this.getIndexedDescription(4, 1, "Color", "Monochrome");
    }

    @Nullable
    public String getQualityDescription() {
        return this.getIndexedDescription(3, 1, "VGA Basic", "VGA Normal", "VGA Fine", "SXGA Basic", "SXGA Normal", "SXGA Fine");
    }
}

