/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPIterator;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.xmp.XmpDirectory;
import java.util.Arrays;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmpReader
implements JpegSegmentMetadataReader {
    private static final int FMT_STRING = 1;
    private static final int FMT_RATIONAL = 2;
    private static final int FMT_INT = 3;
    private static final int FMT_DOUBLE = 4;
    private static final int FMT_STRING_ARRAY = 5;
    @NotNull
    private static final String SCHEMA_XMP_PROPERTIES = "http://ns.adobe.com/xap/1.0/";
    @NotNull
    private static final String SCHEMA_EXIF_SPECIFIC_PROPERTIES = "http://ns.adobe.com/exif/1.0/";
    @NotNull
    private static final String SCHEMA_EXIF_ADDITIONAL_PROPERTIES = "http://ns.adobe.com/exif/1.0/aux/";
    @NotNull
    private static final String SCHEMA_EXIF_TIFF_PROPERTIES = "http://ns.adobe.com/tiff/1.0/";
    @NotNull
    public static final String XMP_JPEG_PREAMBLE = "http://ns.adobe.com/xap/1.0/\u0000";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APP1);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        for (byte[] segmentBytes : segments) {
            int preambleLength;
            if (segmentBytes.length < (preambleLength = XMP_JPEG_PREAMBLE.length()) || !XMP_JPEG_PREAMBLE.equalsIgnoreCase(new String(segmentBytes, 0, preambleLength))) continue;
            byte[] xmlBytes = new byte[segmentBytes.length - preambleLength];
            System.arraycopy(segmentBytes, preambleLength, xmlBytes, 0, xmlBytes.length);
            this.extract(xmlBytes, metadata);
        }
    }

    public void extract(@NotNull byte[] xmpBytes, @NotNull Metadata metadata) {
        XmpDirectory directory = new XmpDirectory();
        try {
            XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer(xmpBytes);
            XmpReader.processXmpTags(directory, xmpMeta);
        }
        catch (XMPException e) {
            directory.addError("Error processing XMP data: " + e.getMessage());
        }
        if (!directory.isEmpty()) {
            metadata.addDirectory(directory);
        }
    }

    public void extract(@NotNull String xmpString, @NotNull Metadata metadata) {
        XmpDirectory directory = new XmpDirectory();
        try {
            XMPMeta xmpMeta = XMPMetaFactory.parseFromString(xmpString);
            XmpReader.processXmpTags(directory, xmpMeta);
        }
        catch (XMPException e) {
            directory.addError("Error processing XMP data: " + e.getMessage());
        }
        if (!directory.isEmpty()) {
            metadata.addDirectory(directory);
        }
    }

    private static void processXmpTags(XmpDirectory directory, XMPMeta xmpMeta) throws XMPException {
        directory.setXMPMeta(xmpMeta);
        XmpReader.processXmpTag(xmpMeta, directory, 6, 1);
        XmpReader.processXmpTag(xmpMeta, directory, 7, 1);
        XmpReader.processXmpTag(xmpMeta, directory, 8, 1);
        XmpReader.processXmpTag(xmpMeta, directory, 9, 1);
        XmpReader.processXmpTag(xmpMeta, directory, 1, 1);
        XmpReader.processXmpTag(xmpMeta, directory, 2, 1);
        XmpReader.processXmpTag(xmpMeta, directory, 3, 1);
        XmpReader.processXmpTag(xmpMeta, directory, 12, 3);
        XmpReader.processXmpTag(xmpMeta, directory, 11, 2);
        XmpReader.processXmpTag(xmpMeta, directory, 5, 2);
        XmpReader.processXmpTag(xmpMeta, directory, 10, 2);
        XmpReader.processXmpTag(xmpMeta, directory, 4, 2);
        XmpReader.processXmpDateTag(xmpMeta, directory, 13);
        XmpReader.processXmpDateTag(xmpMeta, directory, 14);
        XmpReader.processXmpTag(xmpMeta, directory, 4097, 4);
        XmpReader.processXmpTag(xmpMeta, directory, 8192, 1);
        XmpReader.processXmpTag(xmpMeta, directory, XmpDirectory.TAG_SUBJECT, 5);
        XMPIterator iterator = xmpMeta.iterator();
        while (iterator.hasNext()) {
            XMPPropertyInfo propInfo = (XMPPropertyInfo)iterator.next();
            String path = propInfo.getPath();
            String value = propInfo.getValue();
            if (path == null || value == null) continue;
            directory.addProperty(path, value);
        }
    }

    private static void processXmpTag(@NotNull XMPMeta meta, @NotNull XmpDirectory directory, int tagType, int formatCode) throws XMPException {
        String propName;
        String schemaNS = XmpDirectory._tagSchemaMap.get(tagType);
        String property = meta.getPropertyString(schemaNS, propName = XmpDirectory._tagPropNameMap.get(tagType));
        if (property == null) {
            return;
        }
        switch (formatCode) {
            case 2: {
                String[] rationalParts = property.split("/", 2);
                if (rationalParts.length == 2) {
                    try {
                        Rational rational = new Rational((long)Float.parseFloat(rationalParts[0]), (long)Float.parseFloat(rationalParts[1]));
                        directory.setRational(tagType, rational);
                    }
                    catch (NumberFormatException ex) {
                        directory.addError(String.format("Unable to parse XMP property %s as a Rational.", propName));
                    }
                    break;
                }
                directory.addError("Error in rational format for tag " + tagType);
                break;
            }
            case 3: {
                try {
                    directory.setInt(tagType, Integer.valueOf(property));
                }
                catch (NumberFormatException ex) {
                    directory.addError(String.format("Unable to parse XMP property %s as an int.", propName));
                }
                break;
            }
            case 4: {
                try {
                    directory.setDouble(tagType, Double.valueOf(property));
                }
                catch (NumberFormatException ex) {
                    directory.addError(String.format("Unable to parse XMP property %s as an double.", propName));
                }
                break;
            }
            case 1: {
                directory.setString(tagType, property);
                break;
            }
            case 5: {
                int count = meta.countArrayItems(schemaNS, propName);
                String[] array = new String[count];
                for (int i = 1; i <= count; ++i) {
                    array[i - 1] = meta.getArrayItem(schemaNS, propName, i).getValue();
                }
                directory.setStringArray(tagType, array);
                break;
            }
            default: {
                directory.addError(String.format("Unknown format code %d for tag %d", formatCode, tagType));
            }
        }
    }

    private static void processXmpDateTag(@NotNull XMPMeta meta, @NotNull XmpDirectory directory, int tagType) throws XMPException {
        String propName;
        String schemaNS = XmpDirectory._tagSchemaMap.get(tagType);
        Calendar cal = meta.getPropertyCalendar(schemaNS, propName = XmpDirectory._tagPropNameMap.get(tagType));
        if (cal != null) {
            directory.setDate(tagType, cal.getTime());
        }
    }
}

