#!/bin/sh
# postinst script for benno-milter
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    configure)
    if [ ! -d /var/spool/postfix ];then
        echo ""
        echo "Please changes settings in /etc/default/benno-milter to match"
        echo "your MTA configuration."
        echo "Example:"
        echo ""
        echo "SOCKET=/var/spool/benno-milter/benno-milter.sock"
        echo "MILTER_GROUP=benno"
        echo ""
    fi


    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac


# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.

# Automatically added by dh_installinit
if [ -x "/etc/init.d/benno-milter" ]; then
	update-rc.d benno-milter defaults >/dev/null
	invoke-rc.d benno-milter start || exit $?
fi
# End automatically added section


exit 0
