#!/bin/sh
# preinst script for benno-archive
#

set -e

# summary of how this script can be called:
#        * <new-preinst> `install'
#        * <new-preinst> `install' <old-version>
#        * <new-preinst> `upgrade' <old-version>
#        * <old-preinst> `abort-upgrade' <new-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    install|upgrade)
        [ -z "$BENNO_HOME" ] && BENNO_HOME=/opt/benno

        test -d $BENNO_HOME || mkdir $BENNO_HOME

        if ! dpkg-statoverride --list $BENNO_HOME >/dev/null
        then
            chown -R $BENNO_USER:$BENNO_GROUP $BENNO_HOME
            chmod u=rwx,g=rwx,o= $BENNO_HOME
        fi
    ;;

    abort-upgrade)
    ;;

    *)
        echo "preinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
