/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.input;

import de.lwsystems.mailarchive.input.SmtpHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.PlainAuthenticationHandlerFactory;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.server.SMTPServer;

public class SmtpServer {
    private static final Logger LOGGER = Logger.getLogger(SmtpServer.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();
    private static final int LOGCONFIGWATCHPERIOD = 60000;
    static String outputDirectory = "/srv/benno/inbox";
    static Integer smtpPort = 2500;
    static boolean addEnvelopeHeader = true;
    static boolean useTls = false;
    static boolean requireTls = true;
    static String smtpAuthUser;
    static String smtpAuthPass;
    static String keyFile;
    static String keyStoreType;
    static char[] keyStorePass;
    static char[] keyPass;

    public static void main(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("h", false, "print help");
        options.addOption("c", true, "Configuration properties file");
        options.addOption("d", true, "Import directory (default: /srv/benno/inbox)");
        options.addOption("p", true, "Listen port (default: 2500");
        options.addOption("x", false, "Suppress X-REAL-MAILFROM, X-REAL-RCPTTO envelope headers (overridden by -e");
        options.addOption("e", false, "Add envelope headers: X-REAL-MAILFROM, X-REAL-RCPTTO (default true)");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("h")) {
            System.out.print(SmtpServer.getHelp());
            Runtime.getRuntime().exit(1);
        }
        if (cmd.hasOption("c")) {
            try {
                Properties properties = new Properties();
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(cmd.getOptionValue("c")));
                properties.load(stream);
                stream.close();
                smtpPort = Integer.parseInt(properties.getProperty("port"));
                outputDirectory = properties.getProperty("import_directory", "/srv/benno/inbox");
                smtpAuthUser = properties.getProperty("auth_user");
                smtpAuthPass = properties.getProperty("auth_pass");
                keyFile = properties.getProperty("key_file");
                keyStoreType = properties.getProperty("keystore_type", "JKS");
                keyStorePass = properties.getProperty("keystore_pass").toCharArray();
                keyPass = properties.getProperty("key_pass").toCharArray();
                useTls = Boolean.parseBoolean(properties.getProperty("tls_enabled", "false"));
                requireTls = Boolean.parseBoolean(properties.getProperty("tls_required", "true"));
                String envelope_header = properties.getProperty("envelope_header");
                if (envelope_header != null) {
                    addEnvelopeHeader = Boolean.parseBoolean(envelope_header);
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Cannot read configuration properties: " + ex.getMessage()));
            }
        }
        if (cmd.hasOption("p")) {
            smtpPort = Integer.parseInt(cmd.getOptionValue("p"));
        }
        if (cmd.hasOption("d")) {
            outputDirectory = cmd.getOptionValue("d");
        }
        if (cmd.hasOption("x")) {
            addEnvelopeHeader = false;
        }
        if (cmd.hasOption("e")) {
            addEnvelopeHeader = true;
        }
        if (cmd.hasOption("t")) {
            useTls = true;
        }
        try {
            SmtpServer.configureLogging();
            String version = SmtpServer.class.getPackage().getImplementationVersion();
            LOGGER.info((Object)("Start Benno SMTP interface (" + version + ") on port " + smtpPort + " writing to " + outputDirectory));
            System.out.println("Start Benno SMTP interface (" + version + ") on port " + smtpPort + " writing to " + outputDirectory + " (envelope:" + addEnvelopeHeader + ")");
            SmtpHandler.inboxDir = outputDirectory;
            SmtpHandler.addEnvelopeHeader = addEnvelopeHeader;
            SmtpHandler smtpHandler = new SmtpHandler();
            SMTPServer smtpServer = null;
            if (useTls) {
                final SSLContext sslContext = SmtpServer.keyManagement();
                smtpServer = new SMTPServer((MessageHandlerFactory)smtpHandler){

                    @Override
                    public SSLSocket createSSLSocket(Socket socket) throws IOException {
                        InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
                        SSLSocketFactory sf = sslContext.getSocketFactory();
                        SSLSocket s = (SSLSocket)sf.createSocket(socket, remoteAddress.getHostName(), socket.getPort(), true);
                        s.setUseClientMode(false);
                        s.setEnabledProtocols(s.getSupportedProtocols());
                        s.setEnabledCipherSuites(s.getSupportedCipherSuites());
                        return s;
                    }
                };
                smtpServer.setEnableTLS(true);
                if (requireTls) {
                    smtpServer.setRequireTLS(true);
                }
            } else {
                smtpServer = new SMTPServer(smtpHandler);
            }
            smtpServer.setPort(smtpPort);
            smtpServer.setDisableReceivedHeaders(true);
            if (smtpAuthUser != null && smtpAuthPass != null) {
                PlainAuthenticationHandlerFactory p = new PlainAuthenticationHandlerFactory(new UsernamePasswordValidator(){

                    @Override
                    public void login(String arg0, String arg1) throws LoginFailedException {
                        if (!arg0.equalsIgnoreCase(smtpAuthUser) || !arg1.equalsIgnoreCase(smtpAuthPass)) {
                            throw new LoginFailedException("Authentication failure");
                        }
                    }
                });
                LOGGER.info((Object)("SMTP authentication for user \"" + smtpAuthUser + "\" enabled"));
                smtpServer.setAuthenticationHandlerFactory(p);
                smtpServer.setRequireAuth(true);
            }
            smtpServer.start();
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Error accessing output directory " + outputDirectory + ": " + ex.getMessage()));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error starting SMTP interface on " + smtpPort + ": " + ex.getMessage()));
        }
    }

    public static SSLContext keyManagement() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        FileInputStream keyStoreIS = new FileInputStream(keyFile);
        KeyStore ksKeys = null;
        ksKeys = KeyStore.getInstance("JKS");
        ksKeys.load(keyStoreIS, keyStorePass);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ksKeys, keyPass);
        FileInputStream trustStoreIS = new FileInputStream(keyFile);
        KeyStore ksTrust = KeyStore.getInstance(keyStoreType);
        ksTrust.load(trustStoreIS, keyStorePass);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        tmf.init(ksTrust);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }

    public static void configureLogging() throws FactoryConfigurationError {
        String logConfigName = "log4j.xml";
        if (System.getProperty("log4j.configuration") == null) {
            if (new File("/etc/benno/bennosmtp-log4j.xml").exists()) {
                logConfigName = "/etc/benno/bennosmtp-log4j.xml";
                DOMConfigurator.configureAndWatch((String)logConfigName, (long)60000L);
            }
        } else {
            logConfigName = System.getProperty("log4j.configuration");
            DOMConfigurator.configureAndWatch((String)logConfigName, (long)60000L);
        }
        if (System.getProperty("log4j.configuration") == null) {
            URL url = ClassLoader.getSystemResource("log4j.xml");
            DOMConfigurator.configure((URL)url);
        }
    }

    public static String getHelp() {
        String help = "Aufruf: benno-smtp [-h] [-x] [-e] [-c <configfile>] [-d <import directory>] [-p <smtp port>]\n";
        return help;
    }
}

