#!/bin/sh
# preinst script for benno-archive
#

set -e

# summary of how this script can be called:
#        * <new-preinst> `install'
#        * <new-preinst> `install' <old-version>
#        * <new-preinst> `upgrade' <old-version>
#        * <old-preinst> `abort-upgrade' <new-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    install|upgrade)
        [ -z "$BENNO_GROUP" ] && BENNO_GROUP=benno
        [ -z "$BENNO_USER" ] && BENNO_USER=benno
        [ -z "$BENNO_LIB" ] && BENNO_LIB=/opt/benno

        if ! getent group | grep -q "^$BENNO_GROUP:" ; then
            echo -n "Adding group $BENNO_GROUP.."
            addgroup --quiet --system $BENNO_GROUP 2>/dev/null ||true
            echo "..done"
        fi

        if ! getent passwd | grep -q "^$BENNO_USER:"; then
            echo -n "Adding system user $BENNO_USER.."
            adduser --quiet --system --ingroup $BENNO_GROUP --no-create-home \
                    --disabled-password $BENNO_USER 2>/dev/null || true
            echo "..done"
        fi


        test -d $BENNO_LIB || mkdir $BENNO_LIB

        if ! dpkg-statoverride --list $BENNO_LIB >/dev/null
        then
            chown -R $BENNO_USER:$BENNO_GROUP $BENNO_LIB
            chmod u=rwx,g=rx,o= $BENNO_LIB
        fi
    ;;

    abort-upgrade)
    ;;

    *)
        echo "preinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

exit 0
