/*
 * Decompiled with CFR 0.152.
 */
package io.minio.errors;

import io.minio.errors.MinioException;
import io.minio.messages.ErrorResponse;
import okhttp3.Request;
import okhttp3.Response;

public class ErrorResponseException
extends MinioException {
    private final ErrorResponse errorResponse;
    private final Response response;

    public ErrorResponseException(ErrorResponse errorResponse, Response response) {
        super(errorResponse.message());
        this.errorResponse = errorResponse;
        this.response = response;
    }

    public ErrorResponse errorResponse() {
        return this.errorResponse;
    }

    @Override
    public String toString() {
        Request request = this.response.request();
        return "error occured\n" + this.errorResponse.getString() + "\nrequest={method=" + request.method() + ", url=" + request.url() + ", headers=" + request.headers().toString().replaceAll("Signature=([0-9a-f]+)", "Signature=*REDACTED*").replaceAll("Credential=([^/]+)", "Credential=*REDACTED*") + "}\nresponse={code=" + this.response.code() + ", headers=" + this.response.headers() + "}\n";
    }
}

