/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.storage.s3;

import de.lwsystems.mailarchive.archive.storage.IBennoStorage;
import de.lwsystems.mailarchive.archive.storage.IBennoStorageFactory;
import de.lwsystems.mailarchive.config.BoxConfig;
import de.lwsystems.mailarchive.storage.s3.S3BoxStorage;
import de.lwsystems.mailarchive.storage.s3.S3BoxStorageConfig;
import java.io.File;
import java.util.UUID;

public class S3BennoStorageFactory
implements IBennoStorageFactory<S3BoxStorageConfig> {
    public Class<S3BoxStorageConfig> getStorageDriver() {
        return S3BoxStorageConfig.class;
    }

    public String getType() {
        return "s3";
    }

    public IBennoStorage getStorage(BoxConfig config, S3BoxStorageConfig storageConfig, File boxRepositoryDirectory, String identifier) {
        return new S3BoxStorage(storageConfig);
    }

    public S3BoxStorageConfig createStorage(S3BoxStorageConfig templateBoxStorageConfig, String boxName, String bennoPath) {
        S3BoxStorageConfig config = new S3BoxStorageConfig();
        config.setEndpoint(templateBoxStorageConfig.getEndpoint());
        config.setAuthentication(templateBoxStorageConfig.getAuthentication());
        config.setMinioBackend(templateBoxStorageConfig.isMinioBackend());
        config.setBoxName(boxName);
        if (templateBoxStorageConfig.getIdentifier().length() < 1) {
            config.setBucket(String.valueOf(UUID.randomUUID()));
        } else {
            config.setBucket(templateBoxStorageConfig.getIdentifier().toLowerCase());
        }
        if (bennoPath.length() > 0) {
            if (!Character.isLetterOrDigit(bennoPath.charAt(0))) {
                config.setBennoPath(bennoPath.substring(1).toLowerCase());
            } else {
                config.setBennoPath(bennoPath.toLowerCase());
            }
        } else {
            config.setBennoPath(config.getBucket());
        }
        config.setIdentifier(null);
        config.setRegion(templateBoxStorageConfig.getRegion());
        new S3BoxStorage(config).createBucket();
        return config;
    }
}

