/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.storage.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import de.lwsystems.mailarchive.archive.RuntimeArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.storage.IBennoStorage;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.storage.s3.S3BoxStorageConfig;
import de.lwsystems.mailarchive.utils.CompressionUtil;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import io.minio.MinioClient;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidArgumentException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.MinioException;
import io.minio.errors.NoResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;

public class S3BoxStorage
implements IBennoStorage {
    private static final Logger LOGGER = Logger.getLogger(S3BoxStorage.class);
    private final S3BoxStorageConfig s3BoxStorageConfig;
    private AmazonS3 client;

    S3BoxStorage(S3BoxStorageConfig s3BoxStorageConfig) {
        this.s3BoxStorageConfig = s3BoxStorageConfig;
    }

    public boolean exists() {
        return this.doesBucketExist(this.getS3Client());
    }

    public void ensureReadyFor(MailDocument document, String identifier) throws FailedArchivingException {
        this.createBucket();
    }

    public OutputStream getOutStream(final MailDocumentId documentId, final IBox.CompressionType compType) throws IOException, FailedArchivingException {
        int duplicateId = 0;
        String objectName = this.getObjectName(documentId, compType);
        while (this.getS3Client().doesObjectExist(this.getBucketName(), objectName)) {
            objectName = documentId.getHashHex() + ConversionUtil.fromIntToHex((int)(++duplicateId));
        }
        final PipedInputStream inputStream = new PipedInputStream();
        final AmazonS3 s3Client = this.getS3Client();
        final ObjectMetadata metadata = new ObjectMetadata();
        PipedOutputStream outputStream = new PipedOutputStream(inputStream);
        new Thread(new Runnable(){

            @Override
            public void run() {
                s3Client.putObject(S3BoxStorage.this.getBucketName(), S3BoxStorage.this.getObjectName(documentId, compType), (InputStream)inputStream, metadata);
            }
        }).start();
        return outputStream;
    }

    public InputStream getInStream(MailDocumentId id, IBox.CompressionType compType) throws IOException {
        S3Object s3ClientObject;
        AmazonS3 s3Client = this.getS3Client();
        String bucketName = this.getBucketName();
        String objectName = this.getObjectName(id, compType);
        try {
            s3ClientObject = s3Client.getObject(bucketName, objectName);
        }
        catch (Exception ex) {
            s3ClientObject = s3Client.getObject(bucketName, this.getObjectNameFallback(id));
        }
        return s3ClientObject.getObjectContent();
    }

    public boolean hasDocument(MailDocumentId documentId, IBox.CompressionType compType) {
        return this.getS3Client().doesObjectExist(this.getBucketName(), this.getObjectName(documentId, compType));
    }

    private String getObjectName(MailDocumentId documentId, IBox.CompressionType compType) {
        if (!documentId.getScid().equals("")) {
            return this.s3BoxStorageConfig.getBennoPath() + "/" + documentId.getScid() + "/" + documentId.getInternalBoxIndentifier() + ":" + documentId.getHashHex() + documentId.getDuplicateIdHex() + CompressionUtil.getCompressionSuffix((IBox.CompressionType)compType);
        }
        return this.s3BoxStorageConfig.getBennoPath() + "/" + documentId.getInternalBoxIndentifier() + ":" + documentId.getHashHex() + documentId.getDuplicateIdHex() + CompressionUtil.getCompressionSuffix((IBox.CompressionType)compType);
    }

    private String getObjectNameFallback(MailDocumentId documentId) {
        return documentId.getHashHex() + documentId.getDuplicateIdHex();
    }

    private AmazonS3 getS3Client() {
        S3BoxStorageConfig.S3Authentication authentication;
        if (this.client != null) {
            return this.client;
        }
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Boolean.valueOf(true));
        if (this.s3BoxStorageConfig.isMinioBackend().booleanValue()) {
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setSignerOverride("AWSS3V4SignerType");
            builder.withClientConfiguration(clientConfiguration);
        }
        if (this.s3BoxStorageConfig.getEndpoint() != null) {
            AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration(this.s3BoxStorageConfig.getEndpoint(), "us-west-2");
            builder.withEndpointConfiguration(endpoint);
        }
        if ((authentication = this.s3BoxStorageConfig.getAuthentication()) != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(authentication.getAuthKeyId(), authentication.getAuthKey());
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials));
        } else {
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()));
        }
        if (this.s3BoxStorageConfig.getRegion() != null) {
            builder.withRegion(Regions.fromName((String)this.s3BoxStorageConfig.getRegion()));
        }
        this.client = (AmazonS3)builder.build();
        return this.client;
    }

    private String getBucketName() {
        return this.s3BoxStorageConfig.getBucket();
    }

    private boolean bucketExists() {
        AmazonS3 client = this.getS3Client();
        return this.doesBucketExist(client);
    }

    void deleteObjectsInBucket() throws XmlPullParserException {
        ObjectListing objectListing = new ObjectListing();
        MinioClient minioClient = null;
        Iterable results = null;
        if (this.s3BoxStorageConfig.isMinioBackend().booleanValue()) {
            minioClient = this.getMinioClient();
            results = minioClient.listObjects(this.getBucketName());
        } else {
            objectListing = this.client.listObjects(this.getBucketName());
        }
        while (true) {
            if (this.s3BoxStorageConfig.isMinioBackend().booleanValue()) {
                MinioClient finalMinioClient = minioClient;
                results.forEach(object -> {
                    try {
                        finalMinioClient.removeObject(this.getBucketName(), object.toString());
                    }
                    catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidArgumentException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException ex) {
                        throw new RuntimeArchiveException("Objects \"" + this.getBucketName() + "\" canot be deleted.", ex);
                    }
                });
                break;
            }
            Iterator objIter = objectListing.getObjectSummaries().iterator();
            while (objIter.hasNext()) {
                this.client.deleteObject(this.getBucketName(), ((S3ObjectSummary)objIter.next()).getKey());
            }
            if (!objectListing.isTruncated()) break;
            objectListing = this.client.listNextBatchOfObjects(objectListing);
        }
    }

    void createBucket() {
        if (!this.bucketExists()) {
            if (this.s3BoxStorageConfig.isMinioBackend().booleanValue()) {
                try {
                    MinioClient minioClient = this.getMinioClient();
                    minioClient.makeBucket(this.getBucketName());
                }
                catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.client.createBucket(this.getBucketName());
            }
            catch (AmazonServiceException ex) {
                throw new RuntimeArchiveException("Bucket \"" + this.getBucketName() + "\" canot be created.", (Throwable)ex);
            }
            LOGGER.info((Object)("Created bucket " + this.getBucketName()));
        }
    }

    void deleteBucket() {
        if (this.bucketExists()) {
            if (this.s3BoxStorageConfig.isMinioBackend().booleanValue()) {
                try {
                    MinioClient minioClient = this.getMinioClient();
                    this.deleteObjectsInBucket();
                    minioClient.removeBucket(this.getBucketName());
                }
                catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.deleteObjectsInBucket();
                this.client.deleteBucket(this.getBucketName());
            }
            catch (AmazonServiceException | XmlPullParserException ex) {
                throw new RuntimeArchiveException("Bucket \"" + this.getBucketName() + "\" canot be deleted.", ex);
            }
            LOGGER.info((Object)("Deleted bucket " + this.getBucketName()));
        }
    }

    private MinioClient getMinioClient() {
        try {
            return new MinioClient(this.s3BoxStorageConfig.getEndpoint(), this.s3BoxStorageConfig.getAuthentication().getAuthKeyId(), this.s3BoxStorageConfig.getAuthentication().getAuthKey());
        }
        catch (InvalidEndpointException | InvalidPortException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean doesBucketExist(AmazonS3 client) {
        if (this.s3BoxStorageConfig.isMinioBackend().booleanValue()) {
            try {
                return this.getMinioClient().bucketExists(this.getBucketName());
            }
            catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                throw new RuntimeException(e);
            }
        }
        return client.doesBucketExistV2(this.getBucketName());
    }
}

