<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

$sendmail_cmd = $App->getConfig('SENDMAIL_CMD','/usr/sbin/sendmail');
$mail_from = $App->getConfig('MAIL_FROM','benno');

$sessionMailId = $App->getParam('sessionMailId');
$mailTo = $App->getParam('mailTo');
if ($App->getConfig('RESEND_MAILTO') == 'last') {
    $App->setSession('resendMailto',$mailTo);
}

try {
    $rawMail = $Backend->fetchRaw($archive,$sessionMailId);
    // Linebreak in $rawMail must be \r\n. Otherwise the whole mail content
    // (whith headers) will be send as mail body.
    $rawMail = preg_replace('/^Message-Id:/im','X-Benno-Resent-Message-Id:',$rawMail);

    $msgIdHeader = 'Message-ID: <'.uniqid('',true).'@'.php_uname('n').'>';
    $msgIdHeader = 'Message-ID: <'.uniqid('',true).'@'.gethostbyaddr(gethostbyname(gethostname())).'>';

    $send_to = escapeshellarg($mailTo);
    $sendmail = "$sendmail_cmd -i -f $mail_from $send_to";
    $env['BENNOWEB_CONFIG'] = $configfile;

    $fd = array(
        0 => array('pipe', 'r'),
        1 => array('pipe', 'w'),
        2 => array('pipe', 'w')
    );
    $process = proc_open($sendmail, $fd, $pipes, null, $env);
    if (is_resource($process)) {
        // write "<username>$auth_sep<password>"
        fwrite($pipes[0],$msgIdHeader."\r\n".$rawMail);
        fclose($pipes[0]);
    
        // read stdout from script
        $outstring = stream_get_contents($pipes[1]);
        fclose($pipes[1]);
    
        $errstring = stream_get_contents($pipes[2]);
        fclose($pipes[2]);
        $closevalue = proc_close($process);

        if ($errstring) {
            throw new Exception("Error send mail: \"$errstring\" ($closevalue)");
        }
        if ($App->getConfig('MAIL_LOG') == 'true') {
            if ($outstring == '') {
                $outstring = "Sent to $mailTo";
            }
            error_log("SENDMAIL: $outstring");
        }
    }
    else {
        throw new Exception("Cannot exec command \"$sendmail\"");
    }

    $bennoId = QueryResult::getBennoId($sessionMailId);
    $Audit->log("MAIL $archive:".$bennoId.' >> '.$mailTo);
}
catch (Exception $e) {
    $App->log('[a_forward] '.$e->getMessage());
}

// no more output needed!
exit;
?>
