<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2016 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

$permalink = $App->getParam('id');

if ($App->accessLevel() < 1) {      // user not authenticated
    $App->setSession('permalink',$permalink);
    $App->setSession('LOGIN_REDIRECT','permaLink');
    $App->redirect('default');
    // end of request
}

// Redirect from Login
if (!$permalink) {
    $permalink = $App->getSession('permalink');
    $App->unsetSession('LOGIN_REDIRECT');
}

$PermaId = new PermaId();
list($bennoId,$permaArchive) = $PermaId->decrypt($permalink);
$PermaQuery = new Query($permalink,$bennoId);
$PermaQuery->type = 'RepoPath';

try {
    // fresh search, thus we start with position 1
    $QueryResult = $Backend->query($permaArchive,$PermaQuery,0,1);
    if ($QueryResult->found == 0) {
        $App->setMsg('MSG_NOTFOUND');
        $sessionMailId = '';
    }
}
catch (Exception $e) {
    if ($e->getMessage() == 'ID_NOT_FOUND') {
        $App->view = 'showList';
    }
    else {
        $App->log($e->getMessage());
        $App->setMsg($e->getMessage());
    }
}

if ($App->accessLevel() > 1) {      // authenticated user
    // remove BennoId from text field in template
    $QueryResult->Query->text = '';
}
$sessionMailId = $QueryResult->getSessionMailId(0);
$App->view = 'showList';
?>
